<?php
/**
 * The template for displaying archive pages.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
global $LEADZ_STORAGE;
$archive_page_layout	=	get_theme_mod( 'archive_page_layout', $LEADZ_STORAGE['archive_page_layout'] );
if($archive_page_layout == 'full-width') {
	$column = 'col-md-12';
}
else{
	$column = 'col-lg-9 col-md-12';
}

?>
<main id="content" class="site-main">
	<div class="page-header">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-md-12">
					<div class="page-header-box">
						<h1 class="entry-title"><?php 
							$leadz_blog_title_text = leadz_get_archive_title();
							echo wp_kses_data( $leadz_blog_title_text ); ?></h1>
						<?php
							the_archive_description( '<div class="taxonomy-description">', '</div>' );
						?>
						<?php do_action('leadz_action_get_breadcrumb'); ?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="page-content">
		<div class="page-blog-archive">
			<div class="container">
				<div class="row">
					<div class="<?php echo esc_attr( $column ); ?>">
						<div class="row">
					<?php
					while ( have_posts() ) {
						the_post();
						$post_link = get_permalink();
						?>
						<div class="col-lg-4 col-md-6">
							<div class="blog-item wow fadeInUp">
								<div class="blog-featured-image">
									<?php
										if ( has_post_thumbnail() ) {
											printf( '<a href="%s"><figure class="image-anime">%s</figure></a>', esc_url( $post_link ), get_the_post_thumbnail( $post, 'large' ) );
										}
									?>
								</div>

								<div class="blog-item-body">
									<div class="blog-meta">
										<ul>
											<li><?php echo get_the_date(); ?></li>
											<li><?php the_author_posts_link(); ?></li>
										</ul>
									</div>
									<div class="blog-content">
										<?php
											printf( '<h3><a href="%s">%s</a></h3>', esc_url( $post_link ), wp_kses_post( get_the_title() ) );
										?>
									</div>
									<div class="blog-btn">
										<?php
											printf( '<a href="%s" class="readmore-btn"><img src="'.esc_url( $LEADZ_STORAGE['read_more_icon'] ).'"/></a>', esc_url( $post_link ));
										?>
									</div>
								</div>
							</div>    
						</div>
					<?php } ?>
							<div class="col-md-12">
								<?php
									echo get_the_posts_pagination( array(
											'mid_size' => 2,
											'prev_text' => '<i class="fa-solid fa-arrow-left-long"></i>',
											'next_text' => '<i class="fa-solid fa-arrow-right-long"></i>',
										) );
								?>
							</div>
						</div>
					</div>
				<?php 
					if($archive_page_layout == 'with-sidebar'):
						get_sidebar();
					endif;
				?>
				</div>
			</div>
		</div>
	</div>
</main>
