<?php
/**
 * The template for displaying 404 pages (not found).
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
global $LEADZ_STORAGE;
?>
<main id="content" class="site-main">
	<div class="page-header">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-md-12">
					<div class="page-header-box">
						<h1 class="text-anime"><?php echo esc_html__( 'Page Not Found', 'leadz' ); ?></h1>
						<?php do_action('leadz_action_get_breadcrumb');		?>
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<div class="error-page">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="error-page-image">
						<img src="<?php echo LEADZ_THEME_URL; ?>/assets/images/image-404.png" alt="">
					</div>
					<div class="error-page-content">
						<div class="error-page-content-heading">
							<h2 class="text-anime-style-3"><?php echo esc_html__( 'Oops! Page Not Found', 'leadz' ); ?></h2>
						</div>
						<div class="error-page-content-body">
							<p><?php echo esc_html__( 'The page you are looking for does not exist', 'leadz' ); ?></p>
							<a class="btn-default" href="<?php echo esc_url( home_url('/') ); ?>"><?php echo esc_html__( 'Back To Home page', 'leadz' ); ?></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

</main>
