<?php 
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
* Set our Customizer default options
*/
if ( ! function_exists( 'awaiken_generate_defaults' ) ) {
	function awaiken_generate_defaults() {
		global $LEADZ_STORAGE;

		return apply_filters( 'awaiken_customizer_defaults', $LEADZ_STORAGE );
	}
}


/**
 * Customizer Setup and Custom Controls
 *
 */

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class awaiken_initialise_customizer_settings {
	// Get our default values
	private $defaults;

	public function __construct() {
		// Get our Customizer defaults
		$this->defaults = awaiken_generate_defaults();


		// Register sections
		add_action( 'customize_register', array( $this, 'awaiken_add_customizer_sections' ) );
		
		// Register general control
		add_action( 'customize_register', array( $this, 'awaiken_register_general_options_controls' ) );
		
		// Register project control
		add_action( 'customize_register', array( $this, 'awaiken_register_portfolio_options_controls' ) );
		
		// Register Case Study control
		add_action( 'customize_register', array( $this, 'awaiken_register_case_study_options_controls' ) );

		// Register blog control
		add_action( 'customize_register', array( $this, 'awaiken_register_blog_options_controls' ) );
		
		// Register footer control
		add_action( 'customize_register', array( $this, 'awaiken_register_footer_options_controls' ) );
		
	}


	/**
	 * Register the Customizer sections
	 */
	public function awaiken_add_customizer_sections( $wp_customize ) {
		
		// Add section general options
		$wp_customize->add_section( 'general_options' , array(
			'title'      => __( 'General Options', 'leadz' ),
		) );
		
		// Add section project options
		$wp_customize->add_section( 'portfolio_options' , array(
			'title'      => __( 'Project Options', 'leadz' ),
		) );
		
		// Add section case study options
		$wp_customize->add_section( 'case_study_options' , array(
			'title'      => __( 'Case Study Options', 'leadz' ),
		) );
		
		// Add section blog options
		$wp_customize->add_section( 'blog_options' , array(
			'title'      => __( 'Blog Options', 'leadz' ),
		) );
		
		// Add section footer options
		$wp_customize->add_section( 'footer_options' , array(
			'title'      => __( 'Footer Options', 'leadz' ),
		) );
		
	}
	
	/**
	 * Register general option controls
	 */

	public function awaiken_register_general_options_controls( $wp_customize ) {  
		
		$section	=	'general_options';
		
		// Preloader
		$wp_customize->add_setting( 'show_preloader',
			array(
				'default' => $this->defaults['show_preloader'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'show_preloader',
			array(
				'label' => __( 'Preloader', 'leadz' ),
				'description' => esc_html__( 'Display preloader while the page is loading.', 'leadz' ),
				'section' => $section
			)
		) );
		
		// Magic Cursor
		$wp_customize->add_setting( 'magic_cursor',
			array(
				'default' => $this->defaults['magic_cursor'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'magic_cursor',
			array(
				'label' => __( 'Magic Cursor', 'leadz' ),
				'description' => esc_html__( 'Show Magic Cursor.', 'leadz' ),
				'section' => $section
			)
		) );
		
		
		// Smooth scrolling
		$wp_customize->add_setting( 'smooth_scrolling',
			array(
				'default' => $this->defaults['smooth_scrolling'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'smooth_scrolling',
			array(
				'label' => __( 'Smooth Scrolling', 'leadz' ),
				'description' => esc_html__( 'Smooth Scrolling Disable/Enable', 'leadz' ),
				'section' => $section
			)
		) );
		
		// heading icon 
		$wp_customize->add_setting( 'show_small_heading_icon',
			array(
				'default' => $this->defaults['show_small_heading_icon'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'show_small_heading_icon',
			array(
				'label' => __( 'Display Small Icon', 'leadz' ),
				'description' => esc_html__( 'Display small icon before small heading.', 'leadz' ),
				'section' => $section
			)
		) );
		
		// heading icon
		$wp_customize->add_setting( 'small_heading_icon',
			array(
				'default' => $this->defaults['small_heading_icon'],
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'small_heading_icon',
			array(
				'label' => __( 'Small heading icon', 'leadz' ),
				'description' => esc_html__( 'If you want to change the current icon, select it here.', 'leadz' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'leadz' ),
					'change' => __( 'Change File', 'leadz' ),
					'default' => __( 'Default', 'leadz' ),
					'remove' => __( 'Remove', 'leadz' ),
					'placeholder' => __( 'No file selected', 'leadz' ),
					'frame_title' => __( 'Select File', 'leadz' ),
					'frame_button' => __( 'Choose File', 'leadz' ),
				)
			)
		) );
		
		// Preloader icon
		$wp_customize->add_setting( 'preloader_icon',
			array(
				'default' => $this->defaults['preloader_icon'],
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'preloader_icon',
			array(
				'label' => __( 'Preloader icon', 'leadz' ),
				'description' => esc_html__( 'If you want to change the current loading icon, select it here.', 'leadz' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'leadz' ),
					'change' => __( 'Change File', 'leadz' ),
					'default' => __( 'Default', 'leadz' ),
					'remove' => __( 'Remove', 'leadz' ),
					'placeholder' => __( 'No file selected', 'leadz' ),
					'frame_title' => __( 'Select File', 'leadz' ),
					'frame_button' => __( 'Choose File', 'leadz' ),
				)
			)
		) );
		

	}
	
	/**
	 * Register project option controls
	 */
	
	public function awaiken_register_portfolio_options_controls( $wp_customize ) { 
			
		$section	=	'portfolio_options';

		// Blog page title 
		$wp_customize->add_setting( 'portfolio_page_title', array(
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'portfolio_page_title', array(
			'type' => 'text',
			'section' => $section,
			'label'       => esc_html__( 'Project Page Archive Title', 'leadz' ),
		) );
		
		// Archive page layout
		$wp_customize->add_setting( 'portfolio_archive_page_layout', array(
		  'default' => $this->defaults['portfolio_archive_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'portfolio_archive_page_layout', array(
			  'label'          => __( 'Project Archive Page Layout', 'leadz' ),
			  'section' => $section,
			  'settings' => 'portfolio_archive_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'leadz' ),
				'with-sidebar'  => __( 'With Sidebar', 'leadz' )
			  ),
		) );
		
		// Archive page single page layout
		$wp_customize->add_setting( 'portfolio_single_page_layout', array(
		  'default' => $this->defaults['portfolio_single_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'portfolio_single_page_layout', array(
			  'label'          => __( 'Project Single Layout', 'leadz' ),
			  'section' => $section,
			  'settings' => 'portfolio_single_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'leadz' ),
				'with-sidebar'  => __( 'With Sidebar', 'leadz' )
			  ),
		) );
		
	}	
	
	/**
	 * Register case study option controls
	 */
	
	public function awaiken_register_case_study_options_controls( $wp_customize ) { 
			
		$section	=	'case_study_options';

		// Blog page title 
		$wp_customize->add_setting( 'case_study_page_title', array(
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'case_study_page_title', array(
			'type' => 'text',
			'section' => $section,
			'label'       => esc_html__( 'Case Study Page Archive Title', 'leadz' ),
		) );
		
		// Archive page layout
		$wp_customize->add_setting( 'case_study_archive_page_layout', array(
		  'default' => $this->defaults['case_study_archive_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'case_study_archive_page_layout', array(
			  'label'          => __( 'Case Study Archive Page Layout', 'leadz' ),
			  'section' => $section,
			  'settings' => 'case_study_archive_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'leadz' ),
				'with-sidebar'  => __( 'With Sidebar', 'leadz' )
			  ),
		) );
		
		// Archive page single page layout
		$wp_customize->add_setting( 'case_study_single_page_layout', array(
		  'default' => $this->defaults['case_study_single_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'case_study_single_page_layout', array(
			  'label'          => __( 'Case Study Single Layout', 'leadz' ),
			  'section' => $section,
			  'settings' => 'case_study_single_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'leadz' ),
				'with-sidebar'  => __( 'With Sidebar', 'leadz' )
			  ),
		) );
		
	}
	
	/**
	 * Register blog option controls
	 */
	
	public function awaiken_register_blog_options_controls( $wp_customize ) { 
			
		$section	=	'blog_options';

		// Blog page title 
		$wp_customize->add_setting( 'blog_page_title', array(
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'blog_page_title', array(
			'type' => 'text',
			'section' => $section,
			'label'       => esc_html__( 'Blog Page Title', 'leadz' ),
		) );
		
		// Archive page layout
		$wp_customize->add_setting( 'archive_page_layout', array(
		  'default' => $this->defaults['archive_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'archive_page_layout', array(
			  'label'          => __( 'Archive Page Layout', 'leadz' ),
			  'section' => $section,
			  'settings' => 'archive_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'leadz' ),
				'with-sidebar'  => __( 'With Sidebar', 'leadz' )
			  ),
		) );
		
		// Archive page single page layout
		$wp_customize->add_setting( 'blog_single_page_layout', array(
		  'default' => $this->defaults['blog_single_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'blog_single_page_layout', array(
			  'label'          => __( 'Blog Single Layout', 'leadz' ),
			  'section' => $section,
			  'settings' => 'blog_single_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'leadz' ),
				'with-sidebar'  => __( 'With Sidebar', 'leadz' )
			  ),
		) );
		
		// Social Sharing
		$wp_customize->add_setting( 'social_sharing',
			array(
				'default' => $this->defaults['social_sharing'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_text_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Pill_Checkbox_Custom_Control( $wp_customize, 'social_sharing',
			array(
				'label' => __( 'Social Sharing', 'leadz' ),
				'description' => esc_html__( 'Choose the social network you want to display in the social share box.', 'leadz' ),
				'section' => $section,
				'input_attrs' => array(
					'sortable' => true,
					'fullwidth' => true,
				),
				'choices' => array(
					'facebook' => esc_attr__( 'Facebook', 'leadz' ),
					'twitter' => esc_attr__( 'Twitter', 'leadz' ),
					'whatsapp' => esc_attr__( 'Whatsapp', 'leadz' ),
					'linkedin' => esc_attr__( 'LinkedIn', 'leadz' ),
					'reddit' => esc_attr__( 'Reddit', 'leadz' ),
					'tumblr' => esc_attr__( 'Tumblr', 'leadz' ),
					'pinterest' => esc_attr__( 'Pinterest', 'leadz' ),
					'vk' => esc_attr__( 'vk', 'leadz' ),
					'email' => esc_attr__( 'Email', 'leadz' ),
					'telegram' => esc_attr__( 'Telegram', 'leadz' ),
				)
			)
		) );

	}
	
	/**
	 * Register footer controls
	 */
	
	public function awaiken_register_footer_options_controls( $wp_customize ) { 
		
		$section	=	'footer_options';
		
		//Footer logo
		$wp_customize->add_setting( 'footer_logo',
			array(
				'default' => '',
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'footer_logo',
			array(
				'label' => __( 'Footer Logo', 'leadz' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'leadz' ),
					'change' => __( 'Change File', 'leadz' ),
					'default' => __( 'Default', 'leadz' ),
					'remove' => __( 'Remove', 'leadz' ),
					'placeholder' => __( 'No file selected', 'leadz' ),
					'frame_title' => __( 'Select File', 'leadz' ),
					'frame_button' => __( 'Choose File', 'leadz' ),
				)
			)
		) );
		
		// Copyright text
		$wp_customize->add_setting( 'footer_copyright_text',
			array(
				'default' => $this->defaults['footer_copyright_text'],
				'transport' => 'refresh',
				'sanitize_callback' => 'wp_kses_post'
			)
		);
		$wp_customize->add_control( 'footer_copyright_text',
			array(
				'label' => __( 'Copyright Text', 'leadz' ),
				'section' => $section,
				'type' => 'textarea',
			)
		);
		
		// Social media URLs
		$wp_customize->add_setting( 'social_urls',
			array(
				'default' => $this->defaults['social_urls'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_url_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Sortable_Repeater_Custom_Control( $wp_customize, 'social_urls',
			array(
				'label' => __( 'Social URLs', 'leadz' ),
				'description' => esc_html__( 'Enter the social profile URLs.', 'leadz' ),
				'section' => $section,
				'button_labels' => array(
					'add' => __( 'Add Row', 'leadz' ),
				)
			)
		) );
		
	}
	
}

/**
 * Load all our Customizer Custom Controls
 */
require_once LEADZ_THEME_DIR . '/inc/customizer/custom-controls.php';

/**
 * Initialise our Customizer settings
 */
$awaiken_settings = new awaiken_initialise_customizer_settings();
