<?php if (!defined('ABSPATH')) exit; ?>
<div class="ct-final2-wrap">

  <!-- Step Indicators -->
  <div class="ct-steps-indicator">
      <div class="step active" data-step="1">1</div>
      <div class="step" data-step="2">2</div>
      <div class="step" data-step="3">3</div>
  </div>

  <!-- =======================
       STEP 1 – MAIN FORM
       ======================= -->
  <div id="ct-step-1" class="ct-step-panel active">
    <h2 class="formheading">Exhibitor Registration - Scale 2026</h2>
    <p class="subheadingtext">Please note, it is compulsory to fill all the fields.</p>

    <form id="ct-final2-form" novalidate>

      <!-- NAME ROW -->
      <div class="row">
        <div class="col">
          <label>Salutation *</label>
          <select name="salutation">
            <option value="Mr">Mr</option>
            <option value="Mrs">Mrs</option>
          </select>
        </div>

        <div class="col">
          <label>First Name *</label>
          <input name="first_name" />
        </div>

        <div class="col">
          <label>Last Name *</label>
          <input name="last_name" />
        </div>
      </div>

      <div class="field"><label>Designation *</label><input name="designation" /></div>
      <div class="field"><label>Company *</label><input name="company" /></div>
      <div class="field"><label>Address Line 1 *</label><input name="address1" /></div>
      <div class="field"><label>Address Line 2</label><input name="address2" /></div>

      <div class="row">
        <div class="col"><label>City *</label><input name="city" /></div>
        <div class="col"><label>Pincode/Zipcode *</label><input name="pincode" /></div>
      </div>

      <div class="row">
        <div class="col">
          <label>Country *</label>
          <select name="country" id="country">
            <?php
            $countries = array(
              'India','United States','United Kingdom','United Arab Emirates','Saudi Arabia',
              'Germany','France','China','Japan','Australia','Canada','Netherlands','Brazil',
              'South Africa','Singapore','Other'
            );
            foreach($countries as $c){
                echo '<option value="'.esc_attr($c).'">'.esc_html($c).'</option>';
            }
            ?>
          </select>
        </div>
        <div class="col">
          <label>Specify Country</label>
          <input name="specify" />
        </div>
      </div>

      <!-- PHONE + EMAIL -->
      <div class="row">
        <div class="col"><label>Mobile Number *</label><input name="mobile" /></div>
        <div class="col"><label>Landline Number</label><input name="landline" /></div>
      </div>

      <div class="field"><label>Email *</label><input name="email" type="email" /></div>
      <div class="field"><label>Website/URL *</label><input name="website" type="url" /></div>

      <!-- OLD AREA FIELD HIDDEN ALWAYS -->
      <input type="hidden" name="area" value="NA" />

      <!-- NEW: STALL SIZE DROPDOWN -->
      <div class="row">
  <div class="col">
    <label>Stall Size *</label>
    <select name="stall_size" id="ct_stall_size" required>
      <option value="">-- Select stall size --</option>
      <?php
      $sizes = get_option('ct_stall_sizes', array());
      if (!empty($sizes)) {
          foreach ($sizes as $s) {
              echo '<option value="'.esc_attr($s['id']).'">'.esc_html($s['name']).'</option>';
          }
      } else {
          echo '<option value="std-6sqm">6 SQ. MTRS. (Standard)</option>';
      }
      ?>
    </select>
  </div>
</div>

<!-- PRICE DISPLAY -->
<div id="ct-selected-price-box" style="margin:10px 0; font-weight:bold; color:#222;">
</div>


      <!-- HIDDEN METADATA -->
      <input type="hidden" name="stall_price_inr" id="stall_price_inr" />
      <input type="hidden" name="stall_price_usd" id="stall_price_usd" />
      <input type="hidden" name="stall_link_inr" id="stall_link_inr" />
      <input type="hidden" name="stall_link_usd" id="stall_link_usd" />

      <div class="actions">
        <button id="ct-register-btn" type="button" class="ct-btn">Register</button>
      </div>

    </form>
  </div>

  <!-- =======================
       STEP 2 – SUMMARY
       ======================= -->
  <div id="ct-step-2" class="ct-step-panel">

    <h2 id="ct-amount-heading">
      Scale 2026 - Book a Stand (Total Amount Payable, Inclusive of 18% GST):
      <span id="ct-heading-price"></span>
    </h2>

    <!-- SUMMARY AUTO GENERATED -->
    <div id="ct-summary"></div>

    <div class="actions">
      <button id="ct-edit-btn" class="ct-btn outline">« Back</button>
      <button id="ct-confirm-btn" class="ct-btn">Submit & Pay Now</button>
    </div>
  </div>

   <!-- =======================
       STEP 3 – PAYMENT STEP
       ======================= -->
  <div id="ct-step-3" class="ct-step-panel">
    <h2 class="formheading">Registration Received – Awaiting Payment Confirmation</h2>
    <p class="subheadingtext">
      Thank you for submitting your registration details.
      Please complete the payment to confirm your participation at Scale 2026.
    </p>

    <div id="ct-success"></div>

    <!-- FINAL PAYMENT BUTTON -->
    <a id="ct-payment-button" href="#" target="_blank" class="payment-btn">
      Proceed to Payment
    </a>

    <div class="actions">
      <button id="ct-finish-btn" class="ct-btn outline">« Back to Form</button>
    </div>
  </div>

</div>

<style>
  .payment-btn {
    background: #045487;
    color: #fff;
    padding: 10px 30px;
    border-radius: 35px;
    border: none;
    cursor: pointer;
    text-decoration: none;
    display: inline-block;
    text-align: center;
  }
  
</style>
