(function($){
  $(document).ready(function(){

    var stallSizes = (typeof ctFinal2 !== 'undefined' && ctFinal2.stall_sizes) ? ctFinal2.stall_sizes : {};

    // -------------------------------
    // SHOW PRICE UNDER DROPDOWN
    // -------------------------------
    function showSelectedPrice(sizeId){
        if (!sizeId || !stallSizes[sizeId]) {
            $("#ct-selected-price-box").html("");
            return;
        }

        let s = stallSizes[sizeId];
        let country = $("#country").val().toLowerCase();
        let finalPrice = (country === "india" || country === "in") ? s.price_inr : s.price_usd;
        let currency = (country === "india" || country === "in") ? "INR " : "USD ";

        $("#ct-selected-price-box").html(
            "<b>Selected Stall Size Price: " + currency + finalPrice + "</b>"
        );

        window.ct_selected_size = s.name;
        window.ct_selected_price = finalPrice;
        window.ct_selected_currency = currency;
        window.ct_link_india = s.link_inr;
        window.ct_link_usd = s.link_usd;
    }

    // -------------------------------
    // UPDATE UI FOR SELECTED STALL
    // -------------------------------
    function updateStallUI(id){
      if (!id || !stallSizes[id]) {
        $('#stall_price_inr').val('');
        $('#stall_price_usd').val('');
        $('#stall_link_inr').val('');
        $('#stall_link_usd').val('');
        showSelectedPrice('');
        return;
      }

      var s = stallSizes[id];

      $('#stall_price_inr').val(s.price_inr);
      $('#stall_price_usd').val(s.price_usd);
      $('#stall_link_inr').val(s.link_inr);
      $('#stall_link_usd').val(s.link_usd);

      showSelectedPrice(id);
    }

    if ($('#ct_stall_size').val()) updateStallUI($('#ct_stall_size').val());

    $('#ct_stall_size').on('change', function(){
      updateStallUI($(this).val());
    });

    $('#country').on('change', function(){
      showSelectedPrice($('#ct_stall_size').val());
    });

    // -------------------------------
    // STEP NAVIGATION
    // -------------------------------
    function gotoStep(n) {
      $('.ct-step-panel').removeClass('active');
      $('#ct-step-' + n).addClass('active');
      $('.ct-steps-indicator .step').removeClass('active');
      $('.ct-steps-indicator .step[data-step="'+n+'"]').addClass('active');
    }

    // -------------------------------
// STEP 1 → STEP 2
// -------------------------------
$('#ct-register-btn').on('click', function(){

  var required = ['[name="salutation"]','[name="first_name"]','[name="last_name"]','[name="company"]','[name="address1"]','[name="city"]','[name="pincode"]','[name="country"]','[name="mobile"]','[name="email"]','[name="website"]','[name="stall_size"]'];
  for (var i=0;i<required.length;i++){
    var el = $(required[i]);
    if (el.length && $.trim(el.val()) === '') {
      alert('Please fill required fields');
      el.focus();
      return;
    }
  }

  function formatLabel(name){
      // remove underscores
      name = name.replace(/_/g, " ");
      // Title Case
      return name.replace(/\b\w/g, c => c.toUpperCase());
  }

  var summary = '<h3>Confirm Your Details</h3><table style="width:100%;border-collapse:collapse;">';

  $('#ct-final2-form').find('input, select').each(function(){
    var name = $(this).attr('name');
    if (!name) return;
    if (name === "area") return;
    if (name.includes("stall_price") || name.includes("stall_link")) return;

    var val = $(this).val();
    if ($.trim(val) === "") val = "-";

    summary += `
      <tr>
        <td style="padding:6px 8px;border-bottom:1px solid #eee;">
            <strong>${formatLabel(name)}</strong>
        </td>
        <td style="padding:6px 8px;border-bottom:1px solid #eee;">${val}</td>
      </tr>
    `;
  });

  summary += `
    <tr>
      <td style="padding:6px 8px;"><strong>Selected Stall Size</strong></td>
      <td style="padding:6px 8px;">${window.ct_selected_size}</td>
    </tr>
    <tr>
      <td style="padding:6px 8px;"><strong>Total Price</strong></td>
      <td style="padding:6px 8px;">${window.ct_selected_currency}${window.ct_selected_price}</td>
    </tr>
  `;

  summary += '</table>';
  $('#ct-summary').html(summary);

  $("#ct-heading-price").html(
      window.ct_selected_currency + window.ct_selected_price
  );

  gotoStep(2);
  $('html,body').animate({scrollTop: $('#ct-step-2').offset().top - 20}, 300);
 });


    // -------------------------------
    // STEP 2 → STEP 3
    // -------------------------------
    $('#ct-confirm-btn').on('click', function(){
      var btn = $(this);
      btn.prop('disabled', true).text('Please wait...');

      var data = {};
      $('#ct-final2-form').find('input,select,textarea').each(function(){
        var name = $(this).attr('name');
        if (!name) return;
        data[name] = $(this).val();
      });

      data.nonce = ctFinal2.nonce;

      $.ajax({
        url: ctFinal2.ajax_url,
        method: 'POST',
        data: $.extend({action:'ct_final2_save'}, data),
        dataType: 'json'
      }).done(function(resp){
        if (resp.success) {
          gotoStep(3);

          let country = $("#country").val().toLowerCase();
          let finalLink = (country === "india" || country === "in")
              ? window.ct_link_india
              : window.ct_link_usd;

          $("#ct-payment-button").attr("href", finalLink);

          $('#ct-success').html(
  `<p style="color:black;background:transparent;border:0px solid #c7f0d0;padding:0px;border-radius:0px;">
      Thank you. Your Registration ID: ${resp.data.id}
      <br><br>
      Scale 2026 - Book a Stand (Total Amount Payable, Inclusive of 18% GST):
      
      ${window.ct_selected_currency}${window.ct_selected_price}
  </p>`
);


        } else {
          alert(resp.data.message || 'Error saving registration');
        }
      }).fail(function(){
        alert('Request failed. Please try again.');
      }).always(function(){
        btn.prop('disabled', false).text('Submit & Pay Now');
      });

    });
    
    // STEP 2 → BACK TO STEP 1  (BACK BUTTON)
$(document).on('click', '#ct-edit-btn', function () {
    gotoStep(1);
    $('html,body').animate({scrollTop: $('#ct-step-1').offset().top - 20}, 300);
});


     // -------------------------------
    // FINISH → BACK TO STEP 1
    // -------------------------------
    $('#ct-finish-btn').on('click', function(){
        gotoStep(1);
        $('#ct-success').html('');
        $('#ct-final2-form')[0].reset();
        updateStallUI('');
        $("#ct-selected-price-box").html("");
    });

  });
})(jQuery);
