<?php
/*
Plugin Name: Custom Featured Blogs
Description: Add blogs with featured and recommended section with shortcode [custom_featured_blogs]. Includes AJAX live search.
Version: 1.1
Author: Sangam Kumar Maurya
*/

if (!defined('ABSPATH')) exit;

// ------------------------
// Register Custom Post Type
// ------------------------
function cfb_register_blog_post_type() {
    $labels = array(
        'name' => 'Custom Blogs',
        'singular_name' => 'Custom Blog',
        'add_new' => 'Add New Blog',
        'add_new_item' => 'Add New Blog',
        'edit_item' => 'Edit Blog',
        'all_items' => 'All Blogs',
        'menu_name' => 'Custom Blogs'
    );

    $args = array(
        'labels' => $labels,
        'public' => true,
        'has_archive' => true,
        'rewrite' => array('slug' => 'cfb-blog'),
        'supports' => array('title', 'editor', 'thumbnail', 'excerpt'),
        'menu_icon' => 'dashicons-welcome-write-blog'
    );

    register_post_type('cfb_blog', $args);
}
add_action('init', 'cfb_register_blog_post_type');


// ------------------------
// Add Featured Checkbox
// ------------------------
function cfb_add_meta_boxes() {
    add_meta_box(
        'cfb_featured_blog',
        'Featured Blog',
        'cfb_featured_blog_callback',
        'cfb_blog',
        'side'
    );
}
add_action('add_meta_boxes', 'cfb_add_meta_boxes');

function cfb_featured_blog_callback($post) {
    wp_nonce_field('cfb_save_featured_meta', 'cfb_featured_nonce');
    $value = get_post_meta($post->ID, '_cfb_featured', true);
    echo '<label><input type="checkbox" name="cfb_featured" value="1" '.checked(1, $value, false).' /> Mark as Featured</label>';
}

function cfb_save_featured_meta($post_id) {
    if (!isset($_POST['cfb_featured_nonce']) || !wp_verify_nonce($_POST['cfb_featured_nonce'], 'cfb_save_featured_meta')) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    if (isset($_POST['cfb_featured'])) {
        update_post_meta($post_id, '_cfb_featured', 1);
    } else {
        delete_post_meta($post_id, '_cfb_featured');
    }
}
add_action('save_post', 'cfb_save_featured_meta');


// ------------------------
// Enqueue Styles & Scripts
// ------------------------
function cfb_enqueue_scripts() {
    wp_enqueue_style('cfb-styles', plugin_dir_url(__FILE__).'css/cfb-styles.css');
    wp_enqueue_script('cfb-ajax', plugin_dir_url(__FILE__).'js/cfb-ajax.js', array('jquery'), null, true);
    wp_localize_script('cfb-ajax', 'cfb_ajax_obj', array(
        'ajaxurl' => admin_url('admin-ajax.php')
    ));
}
add_action('wp_enqueue_scripts', 'cfb_enqueue_scripts');


// ------------------------
// AJAX Live Search Handler
// ------------------------
add_action('wp_ajax_cfb_live_search', 'cfb_live_search');
add_action('wp_ajax_nopriv_cfb_live_search', 'cfb_live_search');

function cfb_live_search(){
    $keyword = isset($_POST['keyword']) ? sanitize_text_field($_POST['keyword']) : '';

    echo cfb_get_blog_grid_html($keyword);
    wp_die();
}

// ------------------------
// Helper function to render blogs
// ------------------------
function cfb_get_blog_grid_html($keyword = '') {
    ob_start();

    // Featured Blogs
    $featured_args = array(
        'post_type' => 'cfb_blog',
        'posts_per_page' => 3,
        'meta_key' => '_cfb_featured',
        'meta_value' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );
    if($keyword) $featured_args['s'] = $keyword;
    $featured_query = new WP_Query($featured_args);

    echo '<h2 class="cfb-heading">Featured Blogs</h2>';
    echo '<div class="cfb-grid cfb-featured">';
    if($featured_query->have_posts()){
        while($featured_query->have_posts()){
            $featured_query->the_post();
            $thumb = get_the_post_thumbnail_url(get_the_ID(), 'medium');
            echo '<a href="'.get_permalink().'" class="cfb-card">';
            echo '<div class="cfb-card-inner" style="background-image: url('.$thumb.');">';
            echo '<div class="cfb-card-content">';
            echo '<h3>'.get_the_title().'</h3>';
            echo '<span>'.get_the_date().'</span>';
            echo '</div></div></a>';
        }
    } else {
        echo '<p>No featured blogs found.</p>';
    }
    echo '</div>';
    wp_reset_postdata();

    // Recommended Blogs
    $recommended_args = array(
        'post_type' => 'cfb_blog',
        'posts_per_page' => 4,
        'meta_query' => array(
            array(
                'key' => '_cfb_featured',
                'compare' => 'NOT EXISTS'
            )
        ),
        'orderby' => 'date',
        'order' => 'DESC',
    );
    if($keyword) $recommended_args['s'] = $keyword;
    $recommended_query = new WP_Query($recommended_args);

    echo '<h2 class="cfb-heading">Recommended Blogs</h2>';
    echo '<div class="cfb-grid cfb-recommended">';
    if($recommended_query->have_posts()){
        while($recommended_query->have_posts()){
            $recommended_query->the_post();
            $thumb = get_the_post_thumbnail_url(get_the_ID(), 'medium');
            echo '<a href="'.get_permalink().'" class="cfb-card">';
            echo '<div class="cfb-card-inner" style="background-image: url('.$thumb.');">';
            echo '<div class="cfb-card-content">';
            echo '<h3>'.get_the_title().'</h3>';
            echo '<span>'.get_the_date().'</span>';
            echo '</div></div></a>';
        }
    } else {
        echo '<p>No recommended blogs found.</p>';
    }
    echo '</div>';
    wp_reset_postdata();

    return ob_get_clean();
}

// ------------------------
// Shortcode
// ------------------------
function cfb_display_blogs() {
    ob_start();

    echo '<div class="cfb-search">';
    echo '<input type="text" placeholder="Search blogs..." />';
    echo '</div>';

    echo '<div class="cfb-section">';
    echo cfb_get_blog_grid_html();
    echo '</div>';

    return ob_get_clean();
}
add_shortcode('custom_featured_blogs', 'cfb_display_blogs');
