<?php
/**
 * The template for displaying singular project.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
global $LEADZ_STORAGE;
while ( have_posts() ) :
	the_post();

	$single_page_layout	=	get_theme_mod( 'portfolio_single_page_layout', 'full-width' );
	if($single_page_layout == 'full-width') {
		$column = 'col-md-12';
	}
	else{
		$column = 'col-lg-9 col-md-12';
	}
?>
<main id="content" <?php post_class( 'site-main' ); ?>>
	<div class="page-header">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-md-12">
					<div class="page-header-box">
						<?php the_title( '<h1 class="text-anime">', '</h1>' ); ?>
						<?php do_action('leadz_action_get_breadcrumb'); ?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="page-single-post single-page">
		<div class="container">
			<div class="row">
				<div class="<?php echo esc_attr( $column ); ?>">
					<?php
						if ( has_post_thumbnail() ) {
							printf( '<div class="post-featured-image"><a href="%s"><figure class="hover-anime">%s</figure></a></div>', esc_url( get_permalink() ), get_the_post_thumbnail( $post, 'large' ) );
						}
					?>
					<div class="post-content">
						<div class="post-entry leadz-block-style">
							<?php the_content(); ?>
							<?php wp_link_pages(); ?>
						</div>
					</div>
					<?php 
						if ( comments_open() || get_comments_number() ) :
						echo '<div class="comment-box">';
							comments_template();
						echo '</div>';
						endif;
					?>
				</div>
				<?php 
					if($single_page_layout == 'with-sidebar'):
						get_sidebar('portfolio');
					endif;
				?>
			</div>
		</div>
	</div>
</main>
<?php
endwhile;
