<?php
/**
 * The template for displaying project.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
global $LEADZ_STORAGE;
$archive_page_layout	=	get_theme_mod( 'portfolio_archive_page_layout', $LEADZ_STORAGE['portfolio_archive_page_layout'] );
if($archive_page_layout == 'full-width') {
	$column = 'col-md-12';
}
else{
	$column = 'col-lg-9 col-md-12';
}

$taxonomies = '';
if(is_post_type_archive('awaiken-project')) {
	$taxonomies = get_terms( array(
		'taxonomy' => 'awaiken-project-category',
		'hide_empty' => true
	) );
}
?>
<main id="content" class="site-main">
	<div class="page-header">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-md-12">
					<div class="page-header-box">
						<h1 class="entry-title"><?php 
									$page_title = leadz_get_archive_title();
									echo wp_kses_data( $page_title ); ?></h1>
								<?php
									the_archive_description( '<div class="taxonomy-description">', '</div>' );
								?>
						<?php do_action('leadz_action_get_breadcrumb'); ?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="page-content">
		<div class="page-project">
			<div class="container">
				<div class="row">
					<div class="<?php echo esc_attr( $column ); ?>">
						<div class="row">
							<div class="col-md-12">
								<div class="elementor-grid-3 elementor-grid-tablet-2 elementor-grid-mobile-1 awaiken-portfolio-gutter-30 elementor-widget leadz-archive-portfolio elementor-widget-soare-portfolio-grid">
									<div id="awaiken-portfolio">
										<?php  if ( !empty($taxonomies) ) { ?>
										<ul class="awaiken-portfolio-grid__filters portfolio_filter-design-1">
												<li class="awaiken-portfolio-grid__filter active" data-filter="*"><?php esc_html_e( 'All', 'leadz' ); ?></li>
											<?php foreach ( $taxonomies as $term ) : ?>
												<li class="awaiken-portfolio-grid__filter-label" data-filter=".awaiken-project-category-<?php echo esc_attr( $term->slug ); ?>"><?php echo esc_html( $term->name ); ?></li>
											<?php endforeach; ?>
										</ul>
										<?php } ?>

									<div class="awaiken-portfolio-grid elementor-grid awaiken-portfolio-layout-grid awaiken-portfolio-item-design-2">
											<?php
											while ( have_posts() ) {
												the_post();
												$post_link = get_permalink();
												?>
												<article <?php post_class( 'awaiken-portfolio-grid-item' ); ?>>
													<div class="awaiken-portfolio-grid-item__wrapper">
														<?php if ( has_post_thumbnail() ) : ?>
														<a class="awaiken-portfolio-grid-item__link" href="<?php echo get_permalink(); ?>">
															<div class="awaiken-portfolio-grid-item__img">
																<?php the_post_thumbnail(); ?>
															</div>
														</a>
														<?php endif; ?>
														<div class="awaiken-portfolio-grid-item__content">
															<div class="awaiken-portfolio-grid-title__wrap">
																<a class="awaiken-portfolio-grid-item__link" href="<?php echo get_permalink(); ?>">
																	<h4 class="awaiken-portfolio-grid-item__title"><?php the_title(); ?></h4>
																</a>
																<div class="awaiken-portfolio-grid-item__excerpt">
																	<?php the_excerpt(); ?>
																</div>
															</div>
															<div class="awaiken-portfolio-grid-item__readmore">
																<a class="awaiken-portfolio-grid-item__link readmore-btn" href="<?php echo esc_url( get_permalink() ); ?>">
																	<img src="<?php echo esc_url( $LEADZ_STORAGE['read_more_icon'] ); ?>" />
																</a>
															</div>
														</div>
														
													</div>
												</article>
											<?php } ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php 
					if($archive_page_layout == 'with-sidebar'):
						get_sidebar('project');
					endif;
				?>
				</div>
			</div>
		</div>
	</div>
</main>