<?php
/**
 * The template for displaying case study.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
global $LEADZ_STORAGE;
$archive_page_layout	=	get_theme_mod( 'case_study_archive_page_layout', $LEADZ_STORAGE['case_study_archive_page_layout'] );
if($archive_page_layout == 'full-width') {
	$column = 'col-md-12';
}
else{
	$column = 'col-lg-9 col-md-12';
}

?>
<main id="content" class="site-main">
	<div class="page-header">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-md-12">
					<div class="page-header-box">
						<h1 class="entry-title"><?php 
									$page_title = leadz_get_archive_title();
									echo wp_kses_data( $page_title ); ?></h1>
								<?php
									the_archive_description( '<div class="taxonomy-description">', '</div>' );
								?>
						<?php do_action('leadz_action_get_breadcrumb'); ?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="page-content">
		<div class="page-case-study">
			<div class="container">
				<div class="row">
					<div class="<?php echo esc_attr( $column ); ?>">
						<div class="row">
					<?php
					while ( have_posts() ) {
						the_post();
						$post_link = get_permalink();
						?>
						<div class="col-lg-4 col-md-6">
							<div class="case-study-item wow fadeInUp">
								<div class="case-study-image">			
									<?php
										if ( has_post_thumbnail() ) {
											printf( '<a href="%s"><figure class="image-anime">%s</figure></a>', esc_url( $post_link ), get_the_post_thumbnail( $post, 'large' ) );
										}
									?>
								</div>

								<div class="case-study-body">
									<div class="case-study-content">
										<?php
											printf( '<h3><a href="%s">%s</a></h3>', esc_url( $post_link ), wp_kses_post( get_the_title() ) );
										?>
									</div>
									<div class="case-study-btn">
										<?php
											printf( '<a href="%s" class="readmore-btn"><img src="'.esc_url( $LEADZ_STORAGE['read_more_icon'] ).'"/></a>', esc_url( $post_link ));
										?>
									</div>
								</div>
							</div>
						</div>
					<?php } ?>
							<div class="col-md-12">
								<?php
									echo get_the_posts_pagination( array(
											'mid_size' => 2,
											'prev_text' => '<i class="fa-solid fa-arrow-left-long"></i>',
											'next_text' => '<i class="fa-solid fa-arrow-right-long"></i>',
										) );
								?>
							</div>
						</div>
					</div>
				<?php 
					if($archive_page_layout == 'with-sidebar'):
						get_sidebar('casestudy');
					endif;
				?>
				</div>
			</div>
		</div>
	</div>
</main>
