<?php
/*
Plugin Name: Whitepaper Manager
Description: Upload PDFs with title and date, display in 3-column grid with live search.
Version: 1.1
Author: Sangam Kumar Maurya
*/

if (!defined('ABSPATH')) exit;

// Register Custom Post Type
add_action('init', function() {
    $labels = array(
        'name' => 'Whitepapers',
        'singular_name' => 'Whitepaper',
        'add_new_item' => 'Add New Whitepaper'
    );

    $args = array(
        'label' => 'Whitepapers',
        'labels' => $labels,
        'public' => true,
        'has_archive' => true,
        'menu_icon' => 'dashicons-media-document',
        'supports' => array('title'),
    );

    register_post_type('whitepaper', $args);
});

// Add Metabox for PDF Upload & Date
add_action('add_meta_boxes', function() {
    add_meta_box('wp_pdf_meta', 'Whitepaper Details', 'wp_pdf_meta_callback', 'whitepaper', 'normal', 'high');
});

function wp_pdf_meta_callback($post) {
    wp_nonce_field('wp_pdf_meta_box', 'wp_pdf_meta_box_nonce');

    $pdf_id = get_post_meta($post->ID, '_wp_pdf_id', true);
    $pdf_url = $pdf_id ? wp_get_attachment_url($pdf_id) : '';
    $date = get_post_meta($post->ID, '_wp_pdf_date', true);

    echo '<p><label>PDF File:</label> ';
    echo '<input type="hidden" id="wp_pdf_id" name="wp_pdf_id" value="'.esc_attr($pdf_id).'"/>';
    echo '<button class="button" id="upload_pdf_button">Upload PDF</button></p>';
    if ($pdf_url) {
        echo '<p>Current PDF: <a href="'.esc_url($pdf_url).'" target="_blank">View PDF</a></p>';
    }

    echo '<p><label>PDF Date:</label> ';
    echo '<input type="date" name="wp_pdf_date" value="'.esc_attr($date).'" /></p>';

    // Enqueue media uploader
    wp_enqueue_media();
    ?>
    <script>
    jQuery(document).ready(function($){
        var file_frame;
        $('#upload_pdf_button').on('click', function(e){
            e.preventDefault();
            if(file_frame) file_frame.open();
            file_frame = wp.media.frames.file_frame = wp.media({
                title: 'Select PDF',
                button: { text: 'Select PDF' },
                multiple: false
            });
            file_frame.on('select', function(){
                var attachment = file_frame.state().get('selection').first().toJSON();
                $('#wp_pdf_id').val(attachment.id);
            });
            file_frame.open();
        });
    });
    </script>
    <?php
}

// Save PDF ID & Date
add_action('save_post', function($post_id) {
    if (!isset($_POST['wp_pdf_meta_box_nonce']) || !wp_verify_nonce($_POST['wp_pdf_meta_box_nonce'], 'wp_pdf_meta_box')) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    // Save Date
    if (isset($_POST['wp_pdf_date'])) {
        update_post_meta($post_id, '_wp_pdf_date', sanitize_text_field($_POST['wp_pdf_date']));
    }

    // Save PDF ID
    if (isset($_POST['wp_pdf_id'])) {
        update_post_meta($post_id, '_wp_pdf_id', intval($_POST['wp_pdf_id']));
    }
});

// Enqueue Scripts & Styles
add_action('wp_enqueue_scripts', function() {
    wp_enqueue_style('wp-grid-style', plugin_dir_url(__FILE__) . 'css/style.css');
    wp_enqueue_script('wp-grid-search', plugin_dir_url(__FILE__) . 'js/search.js', array('jquery'), null, true);
});

// Shortcode to Display Grid
add_shortcode('whitepaper_grid', function() {
    $query = new WP_Query(array(
        'post_type' => 'whitepaper',
        'posts_per_page' => -1
    ));

    ob_start();
    echo '<div class="wp-search-box"><input type="text" id="wp-search-input" placeholder="Search Whitepapers..."></div>';
    echo '<div class="wp-grid">';
    while ($query->have_posts()) : $query->the_post();
        $pdf_id = get_post_meta(get_the_ID(), '_wp_pdf_id', true);
        $pdf_url = $pdf_id ? wp_get_attachment_url($pdf_id) : '';
        $date = get_post_meta(get_the_ID(), '_wp_pdf_date', true);
        $title = get_the_title();
        if (!$pdf_url) continue;
        echo '<div class="wp-box" data-title="'.esc_attr($title).'">
                <h3 class="wp-title">'.esc_html($title).'</h3>
                <p class="wp-date">'.esc_html($date).'</p>
                <a href="'.esc_url($pdf_url).'" target="_blank">View PDF</a>
              </div>';
    endwhile;
    echo '</div>';
    wp_reset_postdata();
    return ob_get_clean();
});
