<?php
/*
Plugin Name: Resources Slider Popup
Description: Resources plugin with conflict-free Swiper slider popup, load more, read more, live search.
Version: 1.0
Author: Sangam Kumar Maurya
*/

if (!defined('ABSPATH')) exit;

// Register CPT
function rp_register_resources_cpt() {
    register_post_type('resource', array(
        'labels'=>array(
            'name'=>'Resources',
            'singular_name'=>'Resource'
        ),
        'public'=>true,
        'has_archive'=>true,
        'supports'=>array('title','editor','thumbnail','custom-fields'),
        'menu_icon'=>'dashicons-media-document'
    ));
}
add_action('init','rp_register_resources_cpt');

// Enqueue assets
function rp_enqueue_assets() {
    wp_enqueue_style('swiper-css','https://cdn.jsdelivr.net/npm/swiper/swiper-bundle.min.css');
    wp_enqueue_script('swiper-js','https://cdn.jsdelivr.net/npm/swiper/swiper-bundle.min.js', array('jquery'), null, true);
    wp_enqueue_style('rp-style', plugin_dir_url(__FILE__) . 'css/resources-style.css');
    wp_enqueue_script('rp-script', plugin_dir_url(__FILE__) . 'js/resources-script.js', array('jquery','swiper-js'), null, true);
    wp_localize_script('rp-script','rp_ajax',array('ajax_url'=>admin_url('admin-ajax.php')));
}
add_action('wp_enqueue_scripts','rp_enqueue_assets');

// Meta box for multiple images
function rp_add_meta_boxes() {
    add_meta_box('rp_images_meta','Resource Images','rp_images_meta_box_callback','resource','normal','high');
}
add_action('add_meta_boxes','rp_add_meta_boxes');

function rp_images_meta_box_callback($post){
    wp_nonce_field('rp_images_meta_box','rp_images_meta_box_nonce');
    $images = get_post_meta($post->ID,'rp_images',true); ?>
    <div id="rp-images-container">
        <button type="button" class="button" id="rp-add-images">Add Images</button>
        <ul id="rp-images-list">
            <?php if($images) {
                foreach($images as $img){
                    echo '<li><img src="'.esc_url($img).'" style="max-width:100px;"><input type="hidden" name="rp_images[]" value="'.esc_url($img).'"><button type="button" class="remove-image">Remove</button></li>';
                }
            } ?>
        </ul>
    </div>
    <script>
    jQuery(document).ready(function($){
        var frame;
        $('#rp-add-images').on('click', function(e){
            e.preventDefault();
            if(frame){ frame.open(); return; }
            frame = wp.media({ title:'Select Images', button:{ text:'Add Images' }, multiple:true });
            frame.on('select', function(){
                var attachments = frame.state().get('selection').toArray();
                attachments.forEach(function(att){
                    var url = att.attributes.url;
                    $('#rp-images-list').append('<li><img src="'+url+'" style="max-width:100px;"><input type="hidden" name="rp_images[]" value="'+url+'"><button type="button" class="remove-image">Remove</button></li>');
                });
            });
            frame.open();
        });
        $(document).on('click','.remove-image', function(){ $(this).parent().remove(); });
    });
    </script>
    <style>
        #rp-images-list{ list-style:none; padding:0; display:flex; flex-wrap:wrap; gap:10px;}
        #rp-images-list li{ position:relative;}
        .remove-image{ position:absolute; top:0; right:0; cursor:pointer;}
    </style>
    <?php
}

function rp_save_meta_box_data($post_id){
    if(!isset($_POST['rp_images_meta_box_nonce']) || !wp_verify_nonce($_POST['rp_images_meta_box_nonce'],'rp_images_meta_box')) return;
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    if(isset($_POST['rp_images'])){
        $images = array_map('esc_url',$_POST['rp_images']);
        update_post_meta($post_id,'rp_images',$images);
    } else {
        delete_post_meta($post_id,'rp_images');
    }
}
add_action('save_post','rp_save_meta_box_data');

// Shortcode
function rp_resources_shortcode(){
    ob_start(); ?>
    <div class="rp-resources-container" id="rp-resources-plugin">
        <input type="text" id="rp-search" placeholder="Search resources...">
        <div id="rp-resources-list"></div>
        <button id="rp-load-more" style="display:none;">Load More</button>
    </div>

    <!-- Custom Swiper Slider Popup -->
    <div id="rp-slider-popup" style="display:none;">
        <div class="rp-slider-overlay"></div>
        <div class="rp-slider-wrapper">
            <button class="rp-slider-close">&times;</button>
            <div class="rp-swiper-container">
                <div class="rp-swiper-wrapper">
                    <!-- Slides injected dynamically -->
                </div>
                <div class="rp-swiper-button-next"></div>
                <div class="rp-swiper-button-prev"></div>
                <div class="rp-swiper-pagination"></div>
            </div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('resources','rp_resources_shortcode');

// AJAX Load
function rp_load_resources(){
    $paged = isset($_POST['paged'])? intval($_POST['paged']):1;
    $search = isset($_POST['search'])? sanitize_text_field($_POST['search']):'';

    $args = array(
        'post_type'=>'resource',
        'posts_per_page'=>6,
        'paged'=>$paged,
        's'=>$search
    );

    $query = new WP_Query($args);
    $found_posts = $query->found_posts;

    if($query->have_posts()){
        while($query->have_posts()){
            $query->the_post();
            $images = get_post_meta(get_the_ID(),'rp_images',true);
            $content = get_the_content();
            $trimmed_content = wp_trim_words($content,40,'...');
            echo '<div class="rp-card" data-postid="'.get_the_ID().'">';
            echo '<h3 class="rp-title">'.get_the_title().'</h3>';
            echo '<div class="rp-date">'.get_the_date().'</div>';
            echo '<div class="rp-desc" data-full="'.esc_attr($content).'">'.$trimmed_content.' <span class="rp-read-more">Read More</span></div>';

            if($images){
                $count = count($images);
                echo '<div class="rp-images" style="position:relative;">';
                // First visible image
                echo '<img src="'.esc_url($images[0]).'" />';
                // Hidden images for slider
                for($i=1;$i<$count;$i++){
                    echo '<img src="'.esc_url($images[$i]).'" style="display:none;" />';
                }
                if($count>1){
                    echo '<div class="rp-more-images">+'.($count-1).'</div>';
                }
                echo '</div>';
            }
            echo '</div>';
        }
        wp_reset_postdata();
    } else {
        echo '<p>No resources found.</p>';
    }

    echo '<input type="hidden" id="rp-total-posts" value="'.$found_posts.'">';
    wp_die();
}
add_action('wp_ajax_rp_load_resources','rp_load_resources');
add_action('wp_ajax_nopriv_rp_load_resources','rp_load_resources');
