jQuery(document).ready(function($){
    let paged = 1;
    let rpSwiper = null;

    function open_slider(images, startIndex=0){
        if(images.length===0) return;
        let wrapper = $('#rp-slider-popup .rp-swiper-wrapper').empty();
        images.forEach(src => {
            wrapper.append('<div class="rp-swiper-slide"><img src="'+src+'" /></div>');
        });

        $('#rp-slider-popup').fadeIn();

        if(rpSwiper) rpSwiper.destroy(true,true);
        rpSwiper = new Swiper('.rp-swiper-container',{
            loop:true,
            navigation:{ nextEl:'.rp-swiper-button-next', prevEl:'.rp-swiper-button-prev' },
            pagination:{ el:'.rp-swiper-pagination', clickable:true },
            initialSlide:startIndex
        });
    }

    // Close popup
    $(document).on('click','.rp-slider-close, .rp-slider-overlay', function(){
        $('#rp-slider-popup').fadeOut();
        if(rpSwiper) rpSwiper.destroy(true,true);
    });

    // Open slider on image / + overlay click
    $(document).on('click','.rp-card .rp-images', function(e){
        e.stopPropagation();
        let postDiv = $(this).closest('.rp-card');
        let images = [];
        postDiv.find('.rp-images img').each(function(){
            images.push($(this).attr('src')); // includes hidden images
        });
        open_slider(images,0);
    });

    // Load resources via AJAX
    function load_resources(paged, search=''){
        $.post(rp_ajax.ajax_url,{action:'rp_load_resources',paged:paged,search:search},function(data){
            if(paged===1) $('#rp-resources-list').html(data);
            else $('#rp-resources-list').append(data);

            let total_posts = parseInt($('#rp-total-posts').val());
            if(total_posts>6) $('#rp-load-more').show();
            else $('#rp-load-more').hide();
        });
    }

    load_resources(paged);

    // Load More / Load Less
    $('#rp-load-more').on('click',function(){
        if($(this).text()==='Load More'){
            paged++;
            load_resources(paged, $('#rp-search').val());
            $(this).text('Load Less');
        } else {
            paged=1;
            load_resources(paged, $('#rp-search').val());
            $(this).text('Load More');
            $('html,body').animate({scrollTop: $('#rp-resources-list').offset().top-50},500);
        }
    });

    // Live search
    $('#rp-search').on('input',function(){
        paged=1;
        $('#rp-load-more').text('Load More');
        load_resources(paged, $(this).val());
    });

    // Read More / Read Less
    $(document).on('click','.rp-read-more',function(){
        let parent = $(this).closest('.rp-desc');
        let fullText = parent.data('full');
        if($(this).text()==='Read More'){
            parent.html(fullText+' <span class="rp-read-more">Read Less</span>');
        } else {
            let trimmed = fullText.split(' ').slice(0,40).join(' ')+'...';
            parent.html(trimmed+' <span class="rp-read-more">Read More</span>');
        }
    });
});
