<?php 
/*
Plugin Name:  Leadz Theme Addons
Plugin URI:   https://awaikenthemes.com
Description:  This plugin is intended for use with the leadz theme.
Version:      1.0.0
Author:       Awaiken Technology
Author URI:   https://awaiken.com
License:      GPL2
License URI:  https://www.gnu.org/licenses/gpl-2.0.html
Text Domain:  leadz-themes-addons
Domain Path:  /languages
*/

define( 'LEADZ_ADDONS_URL', plugins_url( '/', __FILE__ ) );
define( 'LEADZ_ADDONS_PATH', plugin_dir_path( __FILE__ ) );


// Load translation.
add_action( 'init', 'leadz_i18n' );

/**
 * Load the plugin text domain for translation.
 *
 * @since    1.0.0
 */
function leadz_i18n() {
	load_plugin_textdomain( 'leadz-themes-addons' );
}

/* Allow SVG upload */
add_filter( 'wp_check_filetype_and_ext', function( $data, $file, $filename, $mimes ) {

  $filetype = wp_check_filetype( $filename, $mimes );

  return [
      'ext' => $filetype['ext'],
      'type' => $filetype['type'],
      'proper_filename' => $data['proper_filename']
  ];

}, 10, 4 );

function leadz_allow_svg_upload( $mimes ) {
  $mimes['svg'] = 'image/svg+xml';
  $mimes['svgz'] = 'image/svg+xml';
  return $mimes;
}
add_filter( 'upload_mimes', 'leadz_allow_svg_upload' );


/*
* Portfolio CPT
*/
if(!class_exists('Awaiken_Portfolio')) { 
	class Awaiken_Portfolio {

		const CPT_SLUG = 'awaiken-project';
		const TAXONOMY_CATEGORY_SLUG = 'awaiken-project-category';
		
		const CPT_CASESTUDY_SLUG = 'awaiken-casestudy';
		const TAXONOMY_CASESTUDY_CATEGORY_SLUG = 'awaiken-casestudy-category';

		public function register_data() {

			//Project Post Type
			$labels = [
				'name' => esc_html_x( 'Projects', 'Projects', 'leadz-themes-addons' ),
				'singular_name' => esc_html_x( 'Project', 'Project', 'leadz-themes-addons' ),
				'menu_name' => esc_html_x( 'Projects', 'Projects', 'leadz-themes-addons' ),
				'name_admin_bar' => esc_html__( 'Project Item', 'leadz-themes-addons' ),
				'archives' => esc_html__( 'Project Item Archives', 'leadz-themes-addons' ),
				'parent_item_colon' => esc_html__( 'Parent Item:', 'leadz-themes-addons' ),
				'all_items' => esc_html__( 'All Items', 'leadz-themes-addons' ),
				'add_new_item' => esc_html__( 'Add New Project', 'leadz-themes-addons' ),
				'add_new' => esc_html__( 'Add New', 'leadz-themes-addons' ),
				'new_item' => esc_html__( 'New Project', 'leadz-themes-addons' ),
				'edit_item' => esc_html__( 'Edit Project', 'leadz-themes-addons' ),
				'update_item' => esc_html__( 'Update Project', 'leadz-themes-addons' ),
				'view_item' => esc_html__( 'View Project', 'leadz-themes-addons' ),
				'search_items' => esc_html__( 'Search Projects', 'leadz-themes-addons' ),
				'not_found' => esc_html__( 'Not found', 'leadz-themes-addons' ),
				'not_found_in_trash' => esc_html__( 'Not found in Trash', 'leadz-themes-addons' ),
				'featured_image' => esc_html__( 'Featured Image', 'leadz-themes-addons' ),
				'set_featured_image' => esc_html__( 'Set featured image', 'leadz-themes-addons' ),
				'remove_featured_image' => esc_html__( 'Remove featured image', 'leadz-themes-addons' ),
				'use_featured_image' => esc_html__( 'Use as featured image', 'leadz-themes-addons' ),
				'insert_into_item' => esc_html__( 'Insert into Project', 'leadz-themes-addons' ),
				'uploaded_to_this_item' => esc_html__( 'Uploaded to this Project', 'leadz-themes-addons' ),
				'items_list' => esc_html__( 'Items list', 'leadz-themes-addons' ),
				'items_list_navigation' => esc_html__( 'Items list navigation', 'leadz-themes-addons' ),
				'filter_items_list' => esc_html__( 'Filter items list', 'leadz-themes-addons' ),
			];

			$portfolio_slug = apply_filters( 'awaiken_project_slug', 'projects' );

			$rewrite = [
				'slug' => $portfolio_slug,
				'with_front' => false,
			];

			$args = [
				'labels' => $labels,
				'public' => true,
				'menu_position' => 25,
				'menu_icon' => 'dashicons-portfolio',
				'capability_type' => 'post',
				'supports' => [ 'title', 'editor', 'thumbnail', 'author', 'excerpt', 'comments', 'revisions', 'page-attributes', 'custom-fields', 'elementor' ],
				'has_archive' => true,
				'rewrite' => $rewrite,
			];

			register_post_type( self::CPT_SLUG, $args );

			// Categories
			$portfolio_category_slug = apply_filters( 'awaiken_project_category_slug', 'project-category' );

			$rewrite = [
				'slug' => $portfolio_category_slug,
				'with_front' => false,
			];

			$args = [
				'hierarchical' => true,
				'show_ui' => true,
				'show_in_nav_menus' => false,
				'show_admin_column' => true,
				'labels' => $labels,
				'rewrite' => $rewrite,
				'public' => true,
				'labels' => [
					'name' => esc_html_x( 'Categories', 'Project', 'leadz-themes-addons' ),
					'singular_name' => esc_html_x( 'Category', 'Project', 'leadz-themes-addons' ),
					'all_items' => esc_html_x( 'All Categories', 'Project', 'leadz-themes-addons' ),
				],
			];
			register_taxonomy( self::TAXONOMY_CATEGORY_SLUG, self::CPT_SLUG, $args );
			
			//Case Study Post Type 
			$labels = [
				'name' => esc_html_x( 'Case Study', 'Case Study', 'leadz-themes-addons' ),
				'singular_name' => esc_html_x( 'Case Study', 'Case Study', 'leadz-themes-addons' ),
				'menu_name' => esc_html_x( 'Case Study', 'Case Study', 'leadz-themes-addons' ),
				'name_admin_bar' => esc_html__( 'Case Study Item', 'leadz-themes-addons' ),
				'archives' => esc_html__( 'Case Study Item Archives', 'leadz-themes-addons' ),
				'parent_item_colon' => esc_html__( 'Parent Item:', 'leadz-themes-addons' ),
				'all_items' => esc_html__( 'All Items', 'leadz-themes-addons' ),
				'add_new_item' => esc_html__( 'Add New Case Study', 'leadz-themes-addons' ),
				'add_new' => esc_html__( 'Add New', 'leadz-themes-addons' ),
				'new_item' => esc_html__( 'New Case Study', 'leadz-themes-addons' ),
				'edit_item' => esc_html__( 'Edit Case Study', 'leadz-themes-addons' ),
				'update_item' => esc_html__( 'Update Case Study', 'leadz-themes-addons' ),
				'view_item' => esc_html__( 'View Case Study', 'leadz-themes-addons' ),
				'search_items' => esc_html__( 'Search Case Study', 'leadz-themes-addons' ),
				'not_found' => esc_html__( 'Not found', 'leadz-themes-addons' ),
				'not_found_in_trash' => esc_html__( 'Not found in Trash', 'leadz-themes-addons' ),
				'featured_image' => esc_html__( 'Featured Image', 'leadz-themes-addons' ),
				'set_featured_image' => esc_html__( 'Set featured image', 'leadz-themes-addons' ),
				'remove_featured_image' => esc_html__( 'Remove featured image', 'leadz-themes-addons' ),
				'use_featured_image' => esc_html__( 'Use as featured image', 'leadz-themes-addons' ),
				'insert_into_item' => esc_html__( 'Insert into Case Study', 'leadz-themes-addons' ),
				'uploaded_to_this_item' => esc_html__( 'Uploaded to this Case Study', 'leadz-themes-addons' ),
				'items_list' => esc_html__( 'Items list', 'leadz-themes-addons' ),
				'items_list_navigation' => esc_html__( 'Items list navigation', 'leadz-themes-addons' ),
				'filter_items_list' => esc_html__( 'Filter items list', 'leadz-themes-addons' ),
			];

			$casestudy_slug = apply_filters( 'awaiken_casestudy_slug', 'casestudy' );

			$rewrite = [
				'slug' => $casestudy_slug,
				'with_front' => false,
			];

			$args = [
				'labels' => $labels,
				'public' => true,
				'menu_position' => 25,
				'menu_icon' => 'dashicons-analytics',
				'capability_type' => 'post',
				'supports' => [ 'title', 'editor', 'thumbnail', 'author', 'excerpt', 'comments', 'revisions', 'page-attributes', 'custom-fields', 'elementor' ],
				'has_archive' => true,
				'rewrite' => $rewrite,
			];

			register_post_type( self::CPT_CASESTUDY_SLUG, $args );

			// Categories
			$casestudy_category_slug = apply_filters( 'awaiken_casestudy_category_slug', 'casestudy-category' );

			$rewrite = [
				'slug' => $casestudy_category_slug,
				'with_front' => false,
			];

			$args = [
				'hierarchical' => true,
				'show_ui' => true,
				'show_in_nav_menus' => false,
				'show_admin_column' => true,
				'labels' => $labels,
				'rewrite' => $rewrite,
				'public' => true,
				'labels' => [
					'name' => esc_html_x( 'Categories', 'Case Study', 'leadz-themes-addons' ),
					'singular_name' => esc_html_x( 'Category', 'Case Study', 'leadz-themes-addons' ),
					'all_items' => esc_html_x( 'All Categories', 'Case Study', 'leadz-themes-addons' ),
				],
			];
			register_taxonomy( self::TAXONOMY_CASESTUDY_CATEGORY_SLUG, self::CPT_CASESTUDY_SLUG, $args );
		}

		public function __construct() {
			add_action( 'init', [ $this, 'register_data' ], 1 );
		}
	}
	/**
	 * initialize 
	 */
	$Awaiken_Portfolio = new Awaiken_Portfolio();
}