jQuery(document).ready(function ($) {

    /* ======================================================
       SETTINGS
    ====================================================== */
    let perPage = 6;
    let currentCount = perPage;

    $(".dsc-card").css({ opacity: 1, transform: "scale(1)" });

    /* ======================================================
       ARROW SHOW/HIDE FUNCTION
       ✅ Only show if Website, Donor, or Location exists
    ====================================================== */
    function updateArrowVisibility() {
        $(".dsc-card").each(function () {
            var $card = $(this);

            // WEBSITE: check href OR text
            var $websiteBtn = $card.find('.visit-website-btn');
            var hasWebsite = $websiteBtn.length > 0 &&
                             (($websiteBtn.attr('href') && $websiteBtn.attr('href').trim() !== '') ||
                              ($websiteBtn.text().trim() !== ''));

            // DONOR: any text inside donor container
            var hasDonor = $.trim($card.find('.dsc-donor-name').text()) !== '';

            // LOCATION: any text inside location container
            var hasLocation = $.trim($card.find('.dsc-donor-location').text()) !== '';

            // Show arrow if ANY of the three exist
            if (hasWebsite || hasDonor || hasLocation) {
                $card.removeClass('no-expand'); // arrow show
            } else {
                $card.addClass('no-expand');    // arrow hide
            }
        });
    }

    /* ======================================================
       UPDATE CARDS FUNCTION
    ====================================================== */
    function updateCards() {

        let board  = $("select[data-filter='board']").val();
        let broad  = $("select[data-filter='broad']").val();
        let theme  = $("select[data-filter='theme']").val();
        let status = $("select[data-filter='status']").val();
        let search = $("#dsc-search").val().toLowerCase().trim();

        let visibleCards = [];

        $(".dsc-card").each(function () {
            let $card = $(this);
            let match = true;

            if (board  && ($card.data('board')  || '') != board)  match = false;
            if (broad  && ($card.data('broad')  || '') != broad)  match = false;
            if (theme  && ($card.data('theme')  || '') != theme)  match = false;
            if (status && ($card.data('status') || '') != status) match = false;

            if (search) {
                // SEARCH ANY TEXT IN TITLE, DONOR, LOCATION
                let combined =
                    (($card.data('title') || '') +
                     ($card.data('donor') || '') +
                     ($card.data('location') || '')).toLowerCase();
                if (!combined.includes(search)) match = false;
            }

            if (match) visibleCards.push($card);
        });

        $(".dsc-card").hide();
        visibleCards.forEach(function ($card, index) {
            if (index < currentCount) $card.show();
        });

        // Load More / Less button
        if (visibleCards.length > currentCount) {
            $("#dsc-loadmore").text("Load More").show();
        } else if (visibleCards.length > perPage) {
            $("#dsc-loadmore").text("Load Less").show();
        } else {
            $("#dsc-loadmore").hide();
        }

        // Update arrow visibility after showing/hiding cards
        updateArrowVisibility();
    }

    /* ======================================================
       SEARCH / FILTER / RESET
    ====================================================== */
    $(".dsc-filter-dropdown, .dsc-filter-btn").on("change click", function () {
        currentCount = perPage;
        updateCards();
    });

    $("#dsc-search").on("input", function () {
        currentCount = perPage;
        updateCards();
    });

    $("#dsc-reset").on("click", function () {
        $("select.dsc-filter-dropdown").val('');
        $("#dsc-search").val('');
        $('.dsc-dropdown input').prop('checked', false);
        currentCount = perPage;
        updateCards();
    });

    $("#dsc-loadmore").on("click", function () {
        currentCount = ($(this).text() === "Load More") ? currentCount + perPage : perPage;
        updateCards();
    });

    /* ======================================================
       VIEW MORE TOGGLE
    ====================================================== */
    $(document).on("click", ".view-more-btn", function () {
        let $card = $(this).closest(".dsc-card");
        let $details = $card.find(".expanded-details");

        if (!$card.hasClass("dsc-expanded")) {
            $card.addClass("dsc-expanded");
            $details.css('max-height', $details.prop('scrollHeight') + 20);
            $(this).text("↑");
        } else {
            $card.removeClass("dsc-expanded");
            $details.css('max-height', '0px');
            $(this).text("↓");
        }
    });

    /* ======================================================
       DROPDOWN SINGLE OPEN + CHECKBOX FILTER
    ====================================================== */
    $('.dsc-dropbtn').on('click', function (e) {
        e.stopPropagation();
        let parent = $(this).closest('.dsc-dropdown');
        $('.dsc-dropdown').not(parent).removeClass('active');
        parent.toggleClass('active');
    });

    $('.dsc-dropdown-content').on('click', function (e) { e.stopPropagation(); });
    $(document).on('click', function () { $('.dsc-dropdown').removeClass('active'); });

    $('.dsc-dropdown input').on('change', function () {
        let board  = [];
        let theme  = [];
        let status = [];

        $('.dsc-dropdown[data-filter="board"] input:checked').each(function () { board.push($(this).val()); });
        $('.dsc-dropdown[data-filter="theme"] input:checked').each(function () { theme.push($(this).val()); });
        $('.dsc-dropdown[data-filter="status"] input:checked').each(function () { status.push($(this).val()); });

        $(".dsc-card").each(function () {
            let $c = $(this);
            let okBoard  = board.length === 0 || board.includes($c.data('board'));
            let okTheme  = theme.length === 0 || theme.includes($c.data('theme'));
            let okStatus = status.length === 0 || status.includes($c.data('status'));
            $c.toggle(okBoard && okTheme && okStatus);
        });

        // Update arrows after checkbox filter
        updateArrowVisibility();
    });

    /* ======================================================
       INITIALIZE
    ====================================================== */
    updateCards();

});
