<?php
   /*
   Template: Dynamic Status Cards - Template
   */
   ?>
<div class='dsc-filters-container'>
   <div class='dsc-filters'>
      <button class='dsc-filter-btn active' data-filter='all'>All</button>
      <div class="dsc-dropdown-wrapper">
         <div class="dsc-dropdown" data-filter="board">
            <button type="button" class="dsc-dropbtn">Board Category ▼</button>
            <div class="dsc-dropdown-content">
               <label><input type="checkbox" value="Bio Engineering"> Bio Engineering</label>
               <label><input type="checkbox" value="Physical Engineering"> Physical Engineering</label>
            </div>
         </div>
         <div class="dsc-dropdown" data-filter="theme">
            <button type="button" class="dsc-dropbtn">Theme ▼</button>
            <div class="dsc-dropdown-content">
               <label><input type="checkbox" value="Life Sciences & Health"> Life Sciences & Health</label>
               <label><input type="checkbox" value="Energy & Sustainability"> Energy & Sustainability</label>
               <label><input type="checkbox" value="Advanced Materials & Processes"> Advanced Materials & Processes</label>
               <label><input type="checkbox" value="Engineering & Technology Platforms"> Engineering & Technology Platforms</label>
            </div>
         </div>
         <div class="dsc-dropdown" data-filter="status">
            <button type="button" class="dsc-dropbtn">Status ▼</button>
            <div class="dsc-dropdown-content">
               <label><input type="checkbox" value="Green"> Commissioned</label>
               <label><input type="checkbox" value="Yellow"> Under Progress</label>
            </div>
         </div>
      </div>
      <input type='text' id='dsc-search' placeholder='Search...'>
      <button id='dsc-reset'>Reset</button>
   </div>
</div>
<div id='dsc-cards-container' class='dsc-grid'>
   <?php
      $cards = new WP_Query(array('post_type'=>'status_card','posts_per_page'=>-1));
      if($cards->have_posts()):
        while($cards->have_posts()): $cards->the_post();
            $short_desc = get_post_meta(get_the_ID(),'short_desc',true);
            $long_desc = get_post_meta(get_the_ID(),'long_desc',true);
            $sub_heading = get_post_meta(get_the_ID(),'sub_heading',true);
            $board = get_post_meta(get_the_ID(),'board_category',true);
            $theme = get_post_meta(get_the_ID(),'theme',true);
            $classification = get_post_meta(get_the_ID(),'classification',true);
            $status = get_post_meta(get_the_ID(),'status',true);
            $view_link = get_post_meta(get_the_ID(),'view_link',true);
            $logo1 = get_post_meta(get_the_ID(),'logo1',true);
            $logo2 = get_post_meta(get_the_ID(),'logo2',true);
            $donor_name = get_post_meta(get_the_ID(),'donor_name',true);
            $donor_location = get_post_meta(get_the_ID(),'donor_location',true);
            $donor_website = get_post_meta(get_the_ID(),'donor_website',true);
      
            $data_attrs = "data-board='".esc_attr($board)."' data-theme='".esc_attr($theme)."' data-classification='".esc_attr($classification)."' data-status='".esc_attr($status)."' data-title='".esc_attr(get_the_title())."' data-donor='".esc_attr($donor_name)."' data-location='".esc_attr($donor_location)."'";
      
            $status_class = '';
            if(strtolower($status) == 'green'){ 
              $status_class = 'status-green';
            }
            elseif(strtolower($status) == 'yellow'){ 
              $status_class = 'status-yellow';
            }
      
            echo "<div class='dsc-card {$status_class}' $data_attrs>";
              echo "<div class='dsc-card-inner'>";
      
                echo "<div class='dsc-card-head'>";
      
          // Thumbnail
          if (has_post_thumbnail()) {
              $thumb = get_the_post_thumbnail(get_the_ID(),'medium', array('class'=>'dsc-thumb'));
              echo "<div class='dsc-thumb-wrap'>$thumb</div>";
          }
      
          // Header Row: Logo1 → Title + Sub → Logo2
          echo "<div class='dsc-header-row'>";
      
              // 🔹 LEFT SIDE: LOGO1 FIRST
              echo "<div class='dsc-left-row'>";
      
                  // Logo 1 first
                  if ($logo1) {
                      echo "<div class='dsc-logo1'><img src='".esc_url($logo1)."' alt='logo1'></div>";
                  }
      
                  // Title + Subheading second
                  echo "<div class='dsc-title-block'>";
                      echo '<h3 class="dsc-title">'.get_the_title().'</h3>';
                      if ($sub_heading) {
                          echo '<div class="dsc-subheading">'.esc_html($sub_heading).'</div>';
                      }
                  echo "</div>";
      
              echo "</div>";
      
              // 🔹 RIGHT SIDE: LOGO2
              echo "<div class='dsc-right-logo'>";
                  if ($logo2) {
                      echo "<div class='dsc-logo2'><img src='".esc_url($logo2)."'></div>";
                  }
              echo "</div>";
      
          echo "</div>"; // END: header row
      
      echo "</div>"; // END: card head
      
      
                if($short_desc) echo '<div class="dsc-short-desc">'.wp_kses_post($short_desc).'</div>';
      
                // ❌ Status label removed from frontend
      
                echo '<div class="expanded-details" aria-hidden="true">';
       // if($logo2) echo "<div class='dsc-logo2'><img src='".esc_url($logo2)."' alt='logo2' /></div>";
      
        echo '<div class="donor-info-line">';
          if($donor_name) echo "<span class='dsc-donor-name'>Donor Name: ".esc_html($donor_name)."</span>";
          if($donor_location) echo "<span class='dsc-donor-location'>Location: ".esc_html($donor_location)."</span>";
          if($donor_website) echo "<a class='visit-website-btn' href='".esc_url($donor_website)."' target='_blank' rel='noopener'>Visit Website</a>";
        echo '</div>';
       echo '</div>';
      
      
                echo '<div class="dsc-card-foot">';
                  echo '<button class="view-more-btn">↓</button>';
                echo '</div>';
      
              echo "</div>";
            echo "</div>";
      
        endwhile;
      endif;
      wp_reset_postdata();
      ?>
</div>
<button id="dsc-loadmore" class="dsc-loadmore-btn">Load More</button>