<?php
/*
Plugin Name: Dynamic Status Cards
Description: Display dynamic status cards with filters, load more, and detailed donor info.
Version: 3.5
Author: Sangam Kumar Maurya
Email: sangamkmaurya93@gmail.com
*/

if (!defined('ABSPATH')) exit;

// 🔹 Register Custom Post Type
add_action('init', function() {
    register_post_type('status_card', array(
        'public' => true,
        'label' => 'Status Cards',
        'supports' => array('title','thumbnail'),
        'menu_icon' => 'dashicons-feedback'
    ));
});

// 🔹 Enqueue CSS & JS
add_action('wp_enqueue_scripts', function() {
    wp_enqueue_style('dsc-style', plugin_dir_url(__FILE__) . 'css/style.css');
    wp_enqueue_script('dsc-script', plugin_dir_url(__FILE__) . 'js/main.js', array('jquery'), null, true);
});

// 🔹 Shortcode
add_shortcode('status_cards', function() {
    ob_start();
    include plugin_dir_path(__FILE__) . 'templates/card-template.php';
    return ob_get_clean();
});

// 🔹 Add Meta Box
add_action('add_meta_boxes', function() {
    add_meta_box('dsc_card_meta', 'Card Details', 'dsc_card_meta_callback', 'status_card', 'normal', 'high');
});

// 🔹 Meta Box Callback
function dsc_card_meta_callback($post) {
    wp_nonce_field('dsc_save_meta', 'dsc_meta_nonce');

    $board = get_post_meta($post->ID, 'board_category', true);
    $theme = get_post_meta($post->ID, 'theme', true);
    $status = get_post_meta($post->ID, 'status', true);
    $short_desc = get_post_meta($post->ID, 'short_desc', true);
    $sub_heading = get_post_meta($post->ID, 'sub_heading', true);
    $logo1 = get_post_meta($post->ID, 'logo1', true);
    $logo2 = get_post_meta($post->ID, 'logo2', true);
    $donor_name = get_post_meta($post->ID, 'donor_name', true);
    $donor_location = get_post_meta($post->ID, 'donor_location', true);
    $donor_website = get_post_meta($post->ID, 'donor_website', true);

    $boards = ['Bio Engineering', 'Physical Engineering'];
    $themes = [
        'Life Sciences & Health',
        'Energy & Sustainability',
        'Advanced Materials & Processes',
        'Engineering & Technology Platforms'
    ];
    $statuses = ['Green', 'Yellow'];

    echo "<style>.dsc-meta-box input, .dsc-meta-box select, .dsc-meta-box textarea{width:100%;padding:5px;margin-top:3px}</style>";
    echo "<div class='dsc-meta-box'>";

    echo "<p><label><strong>Board Category:</strong></label><br><select name='board_category'>";
    echo "<option value=''>Board Category</option>";
    foreach ($boards as $b) echo "<option value='{$b}' ".selected($board,$b,false).">{$b}</option>";
    echo "</select></p>";

    echo "<p><label><strong>Theme:</strong></label><br><select name='theme'>";
    echo "<option value=''>Theme</option>";
    foreach ($themes as $t) echo "<option value='{$t}' ".selected($theme,$t,false).">{$t}</option>";
    echo "</select></p>";

    echo "<p><label><strong>Status:</strong></label><br><select name='status'>";
    echo "<option value=''>Status</option>";
    foreach ($statuses as $s) echo "<option value='{$s}' ".selected($status,$s,false).">Status {$s}</option>";
    echo "</select></p>";

    echo "<p><label><strong>Sub Heading:</strong></label><br>
    <input type='text' name='sub_heading' value='".esc_attr($sub_heading)."'></p>";

    echo "<p><label><strong>Short Description:</strong></label><br>
    <textarea name='short_desc' rows='3'>".esc_textarea($short_desc)."</textarea></p>";

    echo "<p><label><strong>Logo 1 (Card Top Right):</strong></label><br>
    <input type='url' name='logo1' value='".esc_attr($logo1)."' placeholder='https://'></p>";

    echo "<p><label><strong>Logo 2 (Expanded View):</strong></label><br>
    <input type='url' name='logo2' value='".esc_attr($logo2)."' placeholder='https://'></p>";

    echo "<p><label><strong>Donor Name:</strong></label><br>
    <input type='text' name='donor_name' value='".esc_attr($donor_name)."'></p>";

    echo "<p><label><strong>Location:</strong></label><br>
    <input type='text' name='donor_location' value='".esc_attr($donor_location)."'></p>";

    echo "<p><label><strong>Website (https):</strong></label><br>
    <input type='url' name='donor_website' value='".esc_attr($donor_website)."' placeholder='https://'></p>";

    echo "</div>";
}

// 🔹 Save Meta Data
add_action('save_post', function($post_id) {
    if (!isset($_POST['dsc_meta_nonce']) || !wp_verify_nonce($_POST['dsc_meta_nonce'], 'dsc_save_meta')) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    $fields = [
        'board_category','theme','status','short_desc','sub_heading',
        'logo1','logo2','donor_name','donor_location','donor_website'
    ];

    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            $value = sanitize_text_field($_POST[$field]);
            if (in_array($field, ['logo1','logo2','donor_website'])) $value = esc_url_raw($value);
            update_post_meta($post_id, $field, $value);
        }
    }
});
