<?php
/*
Template: Dynamic Status Cards - Template
*/
?>

<div class="dsc-filters-container">
    <div class="dsc-filters">
        <button class="dsc-filter-btn active" data-filter="all">All</button>

        <div class="dsc-dropdown-wrapper">

            <!-- Board Filter -->
            <div class="dsc-dropdown" data-filter="board">
                <button type="button" class="dsc-dropbtn">Board Category ▼</button>
                <div class="dsc-dropdown-content">
                    <label><input type="checkbox" value="Bio Engineering"> Bio Engineering</label>
                    <label><input type="checkbox" value="Physical Engineering"> Physical Engineering</label>
                </div>
            </div>

            <!-- Theme Filter -->
            <div class="dsc-dropdown" data-filter="theme">
                <button type="button" class="dsc-dropbtn">Theme ▼</button>
                <div class="dsc-dropdown-content">
                    <label><input type="checkbox" value="Life Sciences & Health"> Life Sciences & Health</label>
                    <label><input type="checkbox" value="Energy & Sustainability"> Energy & Sustainability</label>
                    <label><input type="checkbox" value="Advanced Materials & Processes"> Advanced Materials & Processes</label>
                    <label><input type="checkbox" value="Engineering & Technology Platforms"> Engineering & Technology Platforms</label>
                </div>
            </div>

            <!-- Status Filter -->
            <div class="dsc-dropdown" data-filter="status">
                <button type="button" class="dsc-dropbtn">Status ▼</button>
                <div class="dsc-dropdown-content">
                    <label><input type="checkbox" value="Green"> Commissioned</label>
                    <label><input type="checkbox" value="Yellow"> Under Progress</label>
                </div>
            </div>

        </div>

        <input type="text" id="dsc-search" placeholder="Search...">
        <button id="dsc-reset">Reset</button>
    </div>
</div>


<div id="dsc-cards-container" class="dsc-grid">
<?php
$cards = new WP_Query([
    'post_type'      => 'status_card',
    'posts_per_page' => -1
]);

if ($cards->have_posts()) :
    while ($cards->have_posts()) : $cards->the_post();

        /* =====================
         * META VALUES
         * ===================== */
        $short_desc     = get_post_meta(get_the_ID(), 'short_desc', true);
        $sub_heading    = get_post_meta(get_the_ID(), 'sub_heading', true);
        $board          = get_post_meta(get_the_ID(), 'board_category', true);
        $theme          = get_post_meta(get_the_ID(), 'theme', true);
        $classification = get_post_meta(get_the_ID(), 'classification', true);
        $status         = get_post_meta(get_the_ID(), 'status', true);

        $logo1          = get_post_meta(get_the_ID(), 'logo1', true);
        $logo2          = get_post_meta(get_the_ID(), 'logo2', true);
        $donor_name     = get_post_meta(get_the_ID(), 'donor_name', true);
        $donor_location = get_post_meta(get_the_ID(), 'donor_location', true);
        $donor_website  = get_post_meta(get_the_ID(), 'donor_website', true);

        $tags           = get_post_meta(get_the_ID(), 'project_tags', true);

        /* =====================
         * STATUS FLAGS
         * ===================== */
        $is_underprogress = (strtolower($status) === 'yellow');

        $status_class = '';
        if (strtolower($status) === 'green') {
            $status_class = 'status-green';
        } elseif (strtolower($status) === 'yellow') {
            $status_class = 'status-yellow';
        }

        $data_attrs = sprintf(
            "data-board='%s' data-theme='%s' data-classification='%s' data-status='%s' data-title='%s' data-donor='%s' data-location='%s'",
            esc_attr($board),
            esc_attr($theme),
            esc_attr($classification),
            esc_attr($status),
            esc_attr(get_the_title()),
            esc_attr($donor_name),
            esc_attr($donor_location)
        );
        ?>

        <div class="dsc-card <?php echo esc_attr($status_class); ?>" <?php echo $data_attrs; ?>>
            <div class="dsc-card-inner">

                <!-- CARD HEAD -->
                <div class="dsc-card-head">

                    <?php if (has_post_thumbnail()) : ?>
                        <div class="dsc-thumb-wrap">
                            <?php the_post_thumbnail('medium', ['class' => 'dsc-thumb']); ?>
                        </div>
                    <?php endif; ?>

                    <div class="dsc-header-row">

                        <!-- LEFT -->
                        <div class="dsc-left-row">
                            <?php if ($logo1) : ?>
                                <div class="dsc-logo1">
                                    <img src="<?php echo esc_url($logo1); ?>" alt="Logo">
                                </div>
                            <?php endif; ?>

                            <div class="dsc-title-block">
 <div class="dsc-title-row">
        <h3 class="dsc-title"><?php the_title(); ?></h3>

        <?php if (!empty($tags)) : ?>
            <div class="dsc-tags">
                <?php foreach (array_map('trim', explode(',', $tags)) as $tag) : ?>
                    <span class="dsc-tag"><?php echo esc_html($tag); ?></span>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <?php if ($sub_heading) : ?>
        <div class="dsc-subheading"><?php echo esc_html($sub_heading); ?></div>
    <?php endif; ?>

 </div>
</div>

                        <!-- RIGHT -->
                        <div class="dsc-right-logo">
                            <?php if (!$is_underprogress && $logo2) : ?>
                                <div class="dsc-logo2">
                                    <img src="<?php echo esc_url($logo2); ?>" alt="Logo">
                                </div>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>

                <!-- SHORT DESC -->
                <?php if ($short_desc) : ?>
                    <div class="dsc-short-desc"><?php echo wp_kses_post($short_desc); ?></div>
                <?php endif; ?>

                <!-- EXPANDED DETAILS -->
                <div class="expanded-details" aria-hidden="true">
                    <div class="donor-info-line">

                        <?php if (!$is_underprogress) : ?>
                            <?php if ($donor_name) : ?>
                                <span class="dsc-donor-name">Donor Name: <?php echo esc_html($donor_name); ?></span>
                            <?php endif; ?>

                            <?php if ($donor_location) : ?>
                                <span class="dsc-donor-location">Location: <?php echo esc_html($donor_location); ?></span>
                            <?php endif; ?>
                        <?php endif; ?>

                        <?php if ($donor_website) : ?>
                            <a class="visit-website-btn"
                               href="<?php echo esc_url($donor_website); ?>"
                               target="_blank"
                               rel="noopener">
                                Visit Website
                            </a>
                        <?php endif; ?>

                    </div>
                </div>

                <!-- FOOT -->
                <div class="dsc-card-foot">
                    <button class="view-more-btn">↓</button>
                </div>

            </div>
        </div>

    <?php endwhile;
endif;
wp_reset_postdata();
?>
</div>

<div class="dsc-loadmore-wrap">
   <button id="dsc-loadmore" class="dsc-loadmore-btn">Load More</button>
</div>

