jQuery(document).ready(function ($) {
    let perPage = 6;
    let currentCount = perPage;

    // Initial fade CSS apply
    $(".dsc-card").css({
        opacity: 1,
        transition: "opacity 0.35s ease, transform 0.35s ease",
        transform: "scale(1)"
    });

    function updateCards() {
        let board = $("select[data-filter='board']").val();
        let broad = $("select[data-filter='broad']").val();
        let theme = $("select[data-filter='theme']").val();
        let status = $("select[data-filter='status']").val();
        let search = $("#dsc-search").val().toLowerCase().trim();

        let visibleCards = [];

        $(".dsc-card").each(function () {
            let $t = $(this);
            let match = true;

            if (board && ($t.data('board') || '') != board) match = false;
            if (broad && ($t.data('broad') || '') != broad) match = false;
            if (theme && ($t.data('theme') || '') != theme) match = false;
            if (status && ($t.data('status') || '') != status) match = false;

            if (search) {
                let title = ($t.data('title') || '').toString().toLowerCase();
                let donor = ($t.data('donor') || '').toString().toLowerCase();
                let location = ($t.data('location') || '').toString().toLowerCase();
                let combined = title + ' ' + donor + ' ' + location;
                if (combined.indexOf(search) === -1) match = false;
            }

            if (match) {
                $t.show().css({ opacity: 1, transform: 'scale(1)' });
                visibleCards.push($t);
            } else {
                $t.hide().css({ opacity: 0, transform: 'scale(.98)' });
            }
        });

        // Reset Load More logic
        $(".dsc-card").hide();
        visibleCards.forEach(($card, index) => {
            if (index < currentCount) $card.show();
        });

        // Show or hide Load More button
        if (visibleCards.length > currentCount) {
            $("#dsc-loadmore").text("Load More").show();
        } else if (visibleCards.length > perPage) {
            $("#dsc-loadmore").text("Load Less").show();
        } else {
            $("#dsc-loadmore").hide();
        }
    }

    $(".dsc-filter-dropdown, .dsc-filter-btn").on("change click", function () {
        currentCount = perPage;
        updateCards();
    });

    $("#dsc-search").on("input", function () {
        currentCount = perPage;
        updateCards();
    });

    $("#dsc-reset").on("click", function () {
        $("select.dsc-filter-dropdown").val('');
        $("#dsc-search").val('');
        currentCount = perPage;
        updateCards();
    });

    // Load More / View Less
    $("#dsc-loadmore").on("click", function () {
        if ($(this).text() === "Load More") {
            currentCount += perPage;
        } else {
            currentCount = perPage;
        }
        updateCards();
    });

    // View More toggle
    $(document).on("click", ".view-more-btn", function (e) {
        e.preventDefault();
        var $card = $(this).closest(".dsc-card");
        var $details = $card.find(".expanded-details");
        var isExpanded = $card.hasClass("dsc-expanded");

        if (!isExpanded) {
            $card.addClass("dsc-expanded");
            $details.attr("aria-hidden", "false");
            $(this).text("↑");
            var sh = $details.prop('scrollHeight') + 20;
            $details.css('max-height', sh + 'px');
        } else {
            $card.removeClass("dsc-expanded");
            $details.attr("aria-hidden", "true");
            $(this).text("↓");
            $details.css('max-height', '0px');
        }
    });

    updateCards();
});



/* ----------------------------------------------------------
   MULTI-CHECKBOX DROPDOWN FILTERING (Final Stable Version)
------------------------------------------------------------*/
jQuery(document).ready(function ($) {

    // Dropdown toggle
    $('.dsc-dropbtn').on('click', function (e) {
        e.stopPropagation();
        $(this).siblings('.dsc-dropdown-content').slideToggle(150);
    });

    // PREVENT DROPDOWN FROM CLOSING WHEN CLICKING INSIDE
    $('.dsc-dropdown-content').on('click', function (e) {
        e.stopPropagation();
    });

    // Close dropdown only when clicking outside
    $(document).on('click', function () {
        $('.dsc-dropdown-content').slideUp(150);
    });

    // Filter function
    function filterCards() {
        var allCards = $('#dsc-cards-container .dsc-card');

        var boardSelected = [];
        var themeSelected = [];
        var statusSelected = [];

        $('.dsc-dropdown[data-filter="board"] input:checked').each(function () {
            boardSelected.push($(this).val());
        });

        $('.dsc-dropdown[data-filter="theme"] input:checked').each(function () {
            themeSelected.push($(this).val());
        });

        $('.dsc-dropdown[data-filter="status"] input:checked').each(function () {
            statusSelected.push($(this).val());
        });

        allCards.hide().filter(function () {
            var card = $(this);
            var board = card.data('board');
            var theme = card.data('theme');
            var status = card.data('status');

            var boardMatch = boardSelected.length === 0 || boardSelected.includes(board);
            var themeMatch = themeSelected.length === 0 || themeSelected.includes(theme);
            var statusMatch = statusSelected.length === 0 || statusSelected.includes(status);

            return boardMatch && themeMatch && statusMatch;
        }).fadeIn();
    }

    // On checkbox selection
    $('.dsc-dropdown input').on('change', filterCards);

    // Reset
    $('#dsc-reset').on('click', function () {
        $('.dsc-dropdown input').prop('checked', false);
        filterCards();
    });

    filterCards();
});
