<?php
/*
Plugin Name: Newsletter Grid Box
Description: Backend se add karke 3-box grid dikhaye shortcode se with live search. Class prefix newsletterfrmtbox.
Version: 1.0
Author: Sangam Kumar Maurya
*/

if (!defined('ABSPATH')) exit;

// ------------------- Register Custom Post Type -------------------
add_action('init', function () {
    $labels = array(
        'name' => 'Newsletter Boxes',
        'singular_name' => 'Newsletter Box',
        'menu_name' => 'Newsletter Boxes',
        'add_new' => 'Add New Box',
        'add_new_item' => 'Add New Box',
        'edit_item' => 'Edit Box',
        'new_item' => 'New Box',
        'view_item' => 'View Box',
        'all_items' => 'All Boxes',
        'search_items' => 'Search Boxes',
        'not_found' => 'No boxes found',
    );

    $args = array(
        'labels' => $labels,
        'public' => false,
        'show_ui' => true,
        'supports' => array('title', 'thumbnail'),
        'menu_position' => 20,
        'menu_icon' => 'dashicons-layout',
    );

    register_post_type('newsletterfrmtbox', $args);
});

// ------------------- Add Meta Boxes -------------------
add_action('add_meta_boxes', function () {
    add_meta_box('newsletterfrmtbox_meta', 'Box Details', function ($post) {
        wp_nonce_field('newsletterfrmtbox_save', 'newsletterfrmtbox_nonce');

        $link = get_post_meta($post->ID, '_newsletterfrmtbox_link', true);
        $date = get_post_meta($post->ID, '_newsletterfrmtbox_date', true);

        echo '<p><label>Custom Link: </label><br>';
        echo '<input type="url" name="newsletterfrmtbox_link" value="' . esc_attr($link) . '" style="width:100%;"></p>';

        echo '<p><label>Date: </label><br>';
        echo '<input type="date" name="newsletterfrmtbox_date" value="' . esc_attr($date) . '" style="width:100%;"></p>';
    }, 'newsletterfrmtbox', 'normal', 'high');
});

// ------------------- Save Meta Box Data -------------------
add_action('save_post', function ($post_id) {
    if (!isset($_POST['newsletterfrmtbox_nonce']) || !wp_verify_nonce($_POST['newsletterfrmtbox_nonce'], 'newsletterfrmtbox_save')) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    if (isset($_POST['newsletterfrmtbox_link'])) {
        update_post_meta($post_id, '_newsletterfrmtbox_link', sanitize_text_field($_POST['newsletterfrmtbox_link']));
    }

    if (isset($_POST['newsletterfrmtbox_date'])) {
        update_post_meta($post_id, '_newsletterfrmtbox_date', sanitize_text_field($_POST['newsletterfrmtbox_date']));
    }
});

// ------------------- Enqueue Styles & JS -------------------
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_style('newsletterfrmtbox_css', plugins_url('newsletter-grid-box.css', __FILE__));
    wp_enqueue_script('newsletterfrmtbox_js', plugins_url('newsletter-grid-box.js', __FILE__), array('jquery'), false, true);
});

// ------------------- Shortcode -------------------
add_shortcode('newsletterfrmtbox_grid', function ($atts) {
    $query = new WP_Query(array(
        'post_type' => 'newsletterfrmtbox',
        'posts_per_page' => -1,
        'orderby' => 'date',
        'order' => 'DESC',
    ));

    if (!$query->have_posts()) return '<p>No boxes found.</p>';

    $output = '<div class="newsletterfrmtbox-wrapper">';
    $output .= '<div class="newsletterfrmtbox-search-wrapper">';
    $output .= '<input type="text" id="newsletterfrmtbox-search" placeholder="Search by title...">';
    $output .= '</div>';
    $output .= '<div class="newsletterfrmtbox-grid">';

    while ($query->have_posts()) : $query->the_post();
        $link = get_post_meta(get_the_ID(), '_newsletterfrmtbox_link', true);
        $date = get_post_meta(get_the_ID(), '_newsletterfrmtbox_date', true);
        $thumb = get_the_post_thumbnail(get_the_ID(), 'medium');

        $output .= '<div class="newsletterfrmtbox-item">';
        if ($link) $output .= '<a href="' . esc_url($link) . '" target="_blank">';
        $output .= '<div class="newsletterfrmtbox-thumb">' . $thumb . '</div>';
        $output .= '<div class="newsletterfrmtbox-info">';
        $output .= '<h3 class="newsletterfrmtbox-title">' . get_the_title() . '</h3>';
        $output .= '<span class="newsletterfrmtbox-date">' . esc_html($date) . '</span>';
        $output .= '</div>';
        if ($link) $output .= '</a>';
        $output .= '</div>';
    endwhile;

    $output .= '</div></div>';
    wp_reset_postdata();
    return $output;
});
