document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('newsletterfrmtbox-search');
    const boxes = document.querySelectorAll('.newsletterfrmtbox-item');

    searchInput.addEventListener('input', function() {
        const filter = searchInput.value.toLowerCase();

        boxes.forEach(box => {
            const title = box.querySelector('.newsletterfrmtbox-title').textContent.toLowerCase();
            if(title.includes(filter)){
                box.style.display = 'block';
            } else {
                box.style.display = 'none';
            }
        });
    });
});
