<?php
/**
 * Framework slider field.
 *
 * @package    Woo_Gallery_Slider
 * @subpackage Woo_Gallery_Slider/public
 */

if ( ! defined( 'ABSPATH' ) ) {
	die; } // Cannot access directly.

if ( ! class_exists( 'WCGS_Field_slider' ) ) {
	/**
	 *
	 * Field: slider
	 *
	 * @since 1.0.0
	 * @version 1.0.0
	 */
	class WCGS_Field_slider extends WCGS_Fields {

		/**
		 * Field constructor.
		 *
		 * @param array  $field The field type.
		 * @param string $value The values of the field.
		 * @param string $unique The unique ID for the field.
		 * @param string $where To where show the output CSS.
		 * @param string $parent The parent args.
		 */
		public function __construct( $field, $value = '', $unique = '', $where = '', $parent = '' ) {
			parent::__construct( $field, $value, $unique, $where, $parent );
		}

		/**
		 * Render field
		 *
		 * @return void
		 */
		public function render() {

			$args = wp_parse_args(
				$this->field,
				array(
					'max'  => 100,
					'min'  => 0,
					'step' => 1,
					'unit' => '',
				)
			);

			echo wp_kses_post( $this->field_before() );

			echo '<div class="wcgs-table">';
			echo '<div class="wcgs-table-cell wcgs-table-expanded"><div class="wcgs-slider-ui"></div></div>';
			echo '<div class="wcgs-table-cell wcgs-nowrap">';
			echo '<input type="text" name="' . esc_attr( $this->field_name() ) . '" value="' . esc_attr( $this->value ) . '"' . $this->field_attributes() . ' data-max="' . esc_attr( $args['max'] ) . '" data-min="' . esc_attr( $args['min'] ) . '" data-step="' . esc_attr( $args['step'] ) . '" class="wcgs-number" />'; // phpcs:ignore
			echo ( ! empty( $args['unit'] ) ) ? '<em>' . esc_html( $args['unit'] ) . '</em>' : '';
			echo '</div>';
			echo '</div>';

			echo wp_kses_post( $this->field_after() );
		}

		/**
		 * Enqueue
		 *
		 * @return void
		 */
		public function enqueue() {
			if ( ! wp_script_is( 'jquery-ui-slider' ) ) {
				wp_enqueue_script( 'jquery-ui-slider' );
			}
		}
	}
}
