<?php
/*
Plugin Name: Custom Product Filter Apply
Description: Checkbox dropdown based WooCommerce product filter
Version: 7.2
*/

if (!defined('ABSPATH')) exit;

/* ================= TAXONOMIES ================= */

add_action('init', function () {

    register_taxonomy('recipient','product',[
        'label' => 'Recipients',
        'hierarchical' => true,
        'show_ui' => true,
        'show_admin_column' => true
    ]);

    register_taxonomy('occasion','product',[
        'label' => 'Occasions',
        'hierarchical' => true,
        'show_ui' => true,
        'show_admin_column' => true
    ]);

    register_taxonomy('budget_under','product',[
        'label' => 'Budget Under',
        'hierarchical' => true,
        'show_ui' => true,
        'show_admin_column' => true
    ]);

});

/* ================= SHORTCODE ================= */

add_shortcode('custom_product_filter', function(){

    ob_start(); ?>

    <div class="cpf-wrapper">

        <!-- Recipient -->
        <div class="cpf-dropdown">
            <button class="cpf-dd-btn">Recipient <span>▼</span></button>
            <div class="cpf-dd-panel">
                <?php foreach (get_terms(['taxonomy'=>'recipient','hide_empty'=>false]) as $t): ?>
                    <label>
                        <input type="checkbox" class="cpf-recipient" value="<?php echo esc_attr($t->term_id); ?>">
                        <?php echo esc_html($t->name); ?>
                    </label>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Occasion -->
        <div class="cpf-dropdown">
            <button class="cpf-dd-btn">Occasion <span>▼</span></button>
            <div class="cpf-dd-panel">
                <?php foreach (get_terms(['taxonomy'=>'occasion','hide_empty'=>false]) as $t): ?>
                    <label>
                        <input type="checkbox" class="cpf-occasion" value="<?php echo esc_attr($t->term_id); ?>">
                        <?php echo esc_html($t->name); ?>
                    </label>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Budget -->
        <div class="cpf-dropdown">
            <button class="cpf-dd-btn">Budget Under <span>▼</span></button>
            <div class="cpf-dd-panel">
                <?php foreach (get_terms(['taxonomy'=>'budget_under','hide_empty'=>false]) as $t): ?>
                    <label>
                        <input type="checkbox" class="cpf-budget" value="<?php echo esc_attr($t->term_id); ?>">
                        <?php echo esc_html($t->name); ?>
                    </label>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Quantity -->
        <div class="cpf-qty">
            <input type="number" id="cpf-qty" min="1" placeholder="Qty">
        </div>

        <!-- Buttons -->
        <button id="cpf-apply" class="cpf-apply">Apply</button>
        <button id="cpf-reset" class="cpf-reset">Reset</button>

    </div>

    <!-- LOADER (FLASH FIX) -->
    <div id="cpf-loader">
        <span></span>
    </div>

    <!-- RESULTS -->
    <div id="cpf-results"></div>

<?php
    return ob_get_clean();
});

/* ================= AJAX FILTER ================= */

add_action('wp_ajax_cpf_filter','cpf_filter');
add_action('wp_ajax_nopriv_cpf_filter','cpf_filter');

function cpf_filter(){

    $tax_query = ['relation'=>'AND'];

    foreach (['recipient','occasion','budget_under'] as $tax){
        if (!empty($_POST[$tax])) {
            $tax_query[] = [
                'taxonomy' => $tax,
                'field'    => 'term_id',
                'terms'    => array_map('intval', $_POST[$tax])
            ];
        }
    }

    $meta_query = [];
    if (!empty($_POST['qty']) && is_numeric($_POST['qty'])) {
        $meta_query[] = [
            'key'     => '_stock',
            'value'   => (int) $_POST['qty'],
            'compare' => '>=',
            'type'    => 'NUMERIC'
        ];
    }

    $args = [
        'post_type'      => 'product',
        'posts_per_page' => 12,
    ];

    if (count($tax_query) > 1) {
        $args['tax_query'] = $tax_query;
    }

    if (!empty($meta_query)) {
        $args['meta_query'] = $meta_query;
    }

    $q = new WP_Query($args);

    ob_start();

    if ($q->have_posts()) {
        while ($q->have_posts()) {
            $q->the_post();
            wc_get_template_part('content','product');
        }
    } else {
        echo '<p class="cpf-no">No products found</p>';
    }

    wp_reset_postdata();

    wp_send_json([
        'html' => ob_get_clean()
    ]);
}

/* ================= ASSETS ================= */

add_action('wp_enqueue_scripts', function(){

    wp_enqueue_style(
        'cpf-style',
        plugin_dir_url(__FILE__) . 'assets/css/cpf-style.css'
    );

    wp_enqueue_script(
        'cpf-script',
        plugin_dir_url(__FILE__) . 'assets/js/cpf-script.js',
        ['jquery'],
        null,
        true
    );

    wp_localize_script('cpf-script','cpfAjax',[
        'ajaxurl' => admin_url('admin-ajax.php')
    ]);
});
