jQuery(function($){

    function val(el){
        return $(el).val() || [];
    }

    function loadProducts(page = 1){

        $('#cpf-results').fadeTo(150,0.4);

        $.post(cpfAjax.ajaxurl,{
            action: 'cpf_filter',
            recipient: val('.cpf-recipient'),
            occasion: val('.cpf-occasion'),
            budget: val('.cpf-budget'),
            qty: $('#cpf-qty').val(),
            page: page
        },function(res){

            $('#cpf-results').html(res.html).fadeTo(150,1);

            let pg = '';
            for(let i=1;i<=res.max;i++){
                pg += `<button class="cpf-page" data-page="${i}">${i}</button>`;
            }
            $('#cpf-pagination').html(pg);
        });
    }

    $('#cpf-apply').on('click', function(){
        loadProducts();
    });

    $('#cpf-reset').on('click', function(){
        $('.cpf-select').val([]);
        $('#cpf-qty').val('');
        $('#cpf-results, #cpf-pagination').empty();
    });

    $(document).on('click','.cpf-page', function(){
        loadProducts($(this).data('page'));
    });

});

jQuery(function($){

    /* ================= DROPDOWN ================= */

    $('.cpf-dd-btn').on('click', function(e){
        e.preventDefault();
        e.stopPropagation();

        let parent = $(this).closest('.cpf-dropdown');
        $('.cpf-dropdown').not(parent).removeClass('active');
        parent.toggleClass('active');
    });

    $('.cpf-dd-panel').on('click', function(e){
        e.stopPropagation();
    });

    $(document).on('click', function(){
        $('.cpf-dropdown').removeClass('active');
    });

    /* ================= HELPERS ================= */

    function checked(selector){
        return $(selector + ':checked').map(function(){
            return this.value;
        }).get();
    }

    /* ================= APPLY ================= */

    $('#cpf-apply').on('click', function(){

        // show overlay loader (do NOT touch results HTML)
        $('#cpf-loader').addClass('active');

        $.ajax({
            url: cpfAjax.ajaxurl,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'cpf_filter',
                recipient: checked('.cpf-recipient'),
                occasion: checked('.cpf-occasion'),
                budget_under: checked('.cpf-budget'),
                qty: $('#cpf-qty').val()
            },
            success: function(res){
                $('#cpf-results').html(res.html);
            },
            complete: function(){
                $('#cpf-loader').removeClass('active');
            }
        });
    });

    /* ================= RESET ================= */

    $('#cpf-reset').on('click', function(){
        $('input[type=checkbox]').prop('checked', false);
        $('#cpf-qty').val('');
        $('#cpf-results').empty();
        $('.cpf-dropdown').removeClass('active');
    });

});
